/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.wmf2svg.gdi.svg;

import net.arnx.wmf2svg.gdi.svg.SvgGdi;
import net.arnx.wmf2svg.gdi.svg.SvgRegion;
import org.w3c.dom.Element;

class SvgRectRegion
extends SvgRegion {
    private int left;
    private int top;
    private int right;
    private int bottom;

    public SvgRectRegion(SvgGdi gdi, int left, int top, int right, int bottom) {
        super(gdi);
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getRight() {
        return this.right;
    }

    public int getBottom() {
        return this.bottom;
    }

    @Override
    public Element createElement() {
        Element elem = this.getGDI().getDocument().createElement("rect");
        elem.setAttribute("x", "" + (int)this.getGDI().getDC().toAbsoluteX(this.getLeft()));
        elem.setAttribute("y", "" + (int)this.getGDI().getDC().toAbsoluteY(this.getTop()));
        elem.setAttribute("width", "" + (int)this.getGDI().getDC().toRelativeX(this.getRight() - this.getLeft()));
        elem.setAttribute("height", "" + (int)this.getGDI().getDC().toRelativeY(this.getBottom() - this.getTop()));
        return elem;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bottom;
        result = 31 * result + this.left;
        result = 31 * result + this.right;
        result = 31 * result + this.top;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SvgRectRegion other = (SvgRectRegion)obj;
        if (this.bottom != other.bottom) {
            return false;
        }
        if (this.left != other.left) {
            return false;
        }
        if (this.right != other.right) {
            return false;
        }
        return this.top == other.top;
    }
}

