/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.jvm;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.util.JdbcUtils;

public class DerbyConnection
extends JdbcConnection {
    public DerbyConnection() {
    }

    public DerbyConnection(Connection connection) {
        super(connection);
    }

    @Override
    public void commit() throws DatabaseException {
        super.commit();
        this.checkPoint();
    }

    @Override
    public void rollback() throws DatabaseException {
        super.rollback();
        this.checkPoint();
    }

    private void checkPoint() throws DatabaseException {
        Statement st = null;
        try {
            st = this.createStatement();
            String sql = "CALL SYSCS_UTIL.SYSCS_CHECKPOINT_DATABASE()";
            LogService.getLog(this.getClass()).info(LogType.WRITE_SQL, "CALL SYSCS_UTIL.SYSCS_CHECKPOINT_DATABASE()");
            st.execute("CALL SYSCS_UTIL.SYSCS_CHECKPOINT_DATABASE()");
        }
        catch (SQLException e2) {
            throw new DatabaseException(e2);
        }
        finally {
            JdbcUtils.closeStatement(st);
        }
    }
}

