/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.packages;

import java.security.SecureRandom;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import org.docx4j.openpackaging.packages.ProtectionSettings;
import org.docx4j.openpackaging.packages.SpreadsheetMLPackage;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorkbookPart;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorksheetPart;
import org.docx4j.org.apache.poi.poifs.crypt.CryptoFunctions;
import org.docx4j.org.apache.poi.poifs.crypt.HashAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xlsx4j.exceptions.Xlsx4jException;
import org.xlsx4j.sml.CTSheetProtection;
import org.xlsx4j.sml.CTWorkbookProtection;
import org.xlsx4j.sml.Workbook;
import org.xlsx4j.sml.Worksheet;

public class ProtectWorkbook
extends ProtectionSettings {
    protected static Logger log = LoggerFactory.getLogger(ProtectWorkbook.class);

    public ProtectWorkbook(SpreadsheetMLPackage pkg) {
        super(pkg);
    }

    public void removeWorkbookProtection() throws Xlsx4jException {
        WorkbookPart workbookPart = ((SpreadsheetMLPackage)this.pkg).getWorkbookPart();
        if (workbookPart == null) {
            throw new Xlsx4jException("No WorkbookPart in this pkg!");
        }
        Workbook workbook = (Workbook)workbookPart.getJaxbElement();
        if (workbook == null) {
            throw new Xlsx4jException("WorkbookPart not initialised with Workbook content");
        }
        workbook.setWorkbookProtection(null);
    }

    public void setWorkbookProtection(String password, boolean lockRevision, boolean lockStructure, boolean lockWindows) throws Xlsx4jException {
        this.setWorkbookProtection(password, HashAlgorithm.sha512, lockRevision, lockStructure, lockWindows);
    }

    public void setWorkbookProtection(String password, HashAlgorithm hashAlgo, boolean lockRevision, boolean lockStructure, boolean lockWindows) throws Xlsx4jException {
        WorkbookPart workbookPart = ((SpreadsheetMLPackage)this.pkg).getWorkbookPart();
        if (workbookPart == null) {
            throw new Xlsx4jException("No WorkbookPart in this pkg!");
        }
        Workbook workbook = (Workbook)workbookPart.getJaxbElement();
        if (workbook == null) {
            throw new Xlsx4jException("WorkbookPart not initialised with Workbook content");
        }
        CTWorkbookProtection workbookProtection = workbook.getWorkbookProtection();
        if (workbookProtection == null) {
            workbookProtection = new CTWorkbookProtection();
            workbook.setWorkbookProtection(workbookProtection);
        }
        workbookProtection.setLockRevision(Boolean.valueOf(lockRevision));
        workbookProtection.setLockStructure(Boolean.valueOf(lockStructure));
        workbookProtection.setLockWindows(Boolean.valueOf(lockWindows));
        workbookProtection.setWorkbookAlgorithmName(null);
        workbookProtection.setWorkbookSaltValue(null);
        workbookProtection.setWorkbookSpinCount(null);
        workbookProtection.setWorkbookHashValue(null);
        workbookProtection.setWorkbookPassword(null);
        if (hashAlgo == null) {
            hashAlgo = HashAlgorithm.sha512;
        }
        if (password == null) {
            return;
        }
        if (hashAlgo == HashAlgorithm.none) {
            int hash = CryptoFunctions.createXorVerifier1(password);
            workbookProtection.setWorkbookPassword(DatatypeConverter.parseHexBinary((String)Integer.toHexString(hash)));
            return;
        }
        SecureRandom random = new SecureRandom();
        byte[] salt = random.generateSeed(16);
        int spinCount = 100000;
        byte[] hash = CryptoFunctions.hashPassword(password, hashAlgo, salt, spinCount, false);
        if (hashAlgo.jceId.startsWith("SHA")) {
            workbookProtection.setWorkbookAlgorithmName(hashAlgo.jceId);
        } else {
            workbookProtection.setWorkbookAlgorithmName(hashAlgo.ecmaString);
        }
        workbookProtection.setWorkbookSaltValue(salt);
        workbookProtection.setWorkbookSpinCount(Long.valueOf(spinCount));
        workbookProtection.setWorkbookHashValue(hash);
    }

    public boolean validateWorkbookProtectionPassword(String password) throws Xlsx4jException {
        if (password == null) {
            return false;
        }
        WorkbookPart workbookPart = ((SpreadsheetMLPackage)this.pkg).getWorkbookPart();
        if (workbookPart == null) {
            throw new Xlsx4jException("No WorkbookPart in this pkg!");
        }
        Workbook workbook = (Workbook)workbookPart.getJaxbElement();
        if (workbook == null) {
            throw new Xlsx4jException("WorkbookPart not initialised with Workbook content");
        }
        CTWorkbookProtection workbookProtection = workbook.getWorkbookProtection();
        if (workbookProtection == null) {
            return false;
        }
        byte[] xorHashVal = workbookProtection.getWorkbookPassword();
        if (xorHashVal != null) {
            int hash2;
            int hash1 = Integer.parseInt(DatatypeConverter.printHexBinary((byte[])xorHashVal), 16);
            return hash1 == (hash2 = CryptoFunctions.createXorVerifier1(password));
        }
        byte[] hash1 = workbookProtection.getWorkbookHashValue();
        byte[] salt = workbookProtection.getWorkbookSaltValue();
        String algoName = workbookProtection.getWorkbookAlgorithmName();
        Long spinCount = workbookProtection.getWorkbookSpinCount();
        if (hash1 == null || algoName == null || salt == null || spinCount == null) {
            return false;
        }
        HashAlgorithm hashAlgo = HashAlgorithm.fromString(algoName);
        byte[] hash2 = CryptoFunctions.hashPassword(password, hashAlgo, salt, spinCount.intValue(), false);
        return Arrays.equals(hash1, hash2);
    }

    public CTSheetProtection getSheetProtection(WorksheetPart worksheetPart) throws Xlsx4jException {
        CTSheetProtection sheetProtection;
        if (worksheetPart == null) {
            throw new Xlsx4jException("Passed null WorksheetPart");
        }
        if (worksheetPart.getJaxbElement() == null) {
            worksheetPart.setJaxbElement(new Worksheet());
        }
        if ((sheetProtection = ((Worksheet)worksheetPart.getJaxbElement()).getSheetProtection()) == null) {
            sheetProtection = new CTSheetProtection();
            ((Worksheet)worksheetPart.getJaxbElement()).setSheetProtection(sheetProtection);
        }
        sheetProtection.setSheet(Boolean.valueOf(true));
        sheetProtection.setSelectLockedCells(Boolean.valueOf(true));
        sheetProtection.setSelectUnlockedCells(Boolean.valueOf(true));
        return sheetProtection;
    }

    public void setSheetProtectionPassword(CTSheetProtection sheetProtection, String password) throws Xlsx4jException {
        this.setSheetProtection(sheetProtection, password, HashAlgorithm.sha512);
    }

    public void setSheetProtection(CTSheetProtection sheetProtection, String password, HashAlgorithm hashAlgo) throws Xlsx4jException {
        if (sheetProtection == null) {
            throw new Xlsx4jException("Passed null sheetProtection object");
        }
        sheetProtection.setAlgorithmName(null);
        sheetProtection.setSaltValue(null);
        sheetProtection.setSpinCount(null);
        sheetProtection.setHashValue(null);
        sheetProtection.setPassword(null);
        if (hashAlgo == null) {
            hashAlgo = HashAlgorithm.sha512;
        }
        if (password == null) {
            return;
        }
        if (hashAlgo == HashAlgorithm.none) {
            int hash = CryptoFunctions.createXorVerifier1(password);
            sheetProtection.setPassword(DatatypeConverter.parseHexBinary((String)Integer.toHexString(hash)));
            return;
        }
        SecureRandom random = new SecureRandom();
        byte[] salt = random.generateSeed(16);
        int spinCount = 100000;
        byte[] hash = CryptoFunctions.hashPassword(password, hashAlgo, salt, spinCount, false);
        if (hashAlgo.jceId.startsWith("SHA")) {
            sheetProtection.setAlgorithmName(hashAlgo.jceId);
        } else {
            sheetProtection.setAlgorithmName(hashAlgo.ecmaString);
        }
        sheetProtection.setSaltValue(salt);
        sheetProtection.setSpinCount(Long.valueOf(spinCount));
        sheetProtection.setHashValue(hash);
    }

    public static boolean validateSheetProtectionPassword(CTSheetProtection sheetProtection, String password) {
        if (password == null) {
            return false;
        }
        byte[] xorHashVal = sheetProtection.getPassword();
        if (xorHashVal != null) {
            int hash2;
            int hash1 = Integer.parseInt(DatatypeConverter.printHexBinary((byte[])xorHashVal), 16);
            return hash1 == (hash2 = CryptoFunctions.createXorVerifier1(password));
        }
        byte[] hash1 = sheetProtection.getHashValue();
        byte[] salt = sheetProtection.getSaltValue();
        String algoName = sheetProtection.getAlgorithmName();
        Long spinCount = sheetProtection.getSpinCount();
        if (hash1 == null || algoName == null || salt == null || spinCount == null) {
            return false;
        }
        HashAlgorithm hashAlgo = HashAlgorithm.fromString(algoName);
        byte[] hash2 = CryptoFunctions.hashPassword(password, hashAlgo, salt, spinCount.intValue(), false);
        return Arrays.equals(hash1, hash2);
    }
}

