/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core.openxmlformats;

import fr.opensagres.poi.xwpf.converter.core.openxmlformats.IOpenXMLFormatsPartProvider;
import fr.opensagres.poi.xwpf.converter.core.openxmlformats.RelashionShipsHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openxmlformats.schemas.drawingml.x2006.main.ThemeDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocument1;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSettings;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyles;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.DocumentDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.FontsDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.FtrDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.HdrDocument;
import org.xml.sax.SAXException;

public abstract class AbstractOpenXMLFormatsPartProvider
implements IOpenXMLFormatsPartProvider {
    private CTDocument1 document;
    private final Map<String, RelashionShipsHandler> handlers = new HashMap<String, RelashionShipsHandler>();

    @Override
    public CTDocument1 getDocument() throws Exception {
        if (this.document == null) {
            DocumentDocument doc = (DocumentDocument)DocumentDocument.Factory.parse(this.getEntryInputStream("word/document.xml"));
            this.document = doc.getDocument();
        }
        return this.document;
    }

    @Override
    public CTStyles getStyle() throws Exception {
        return this.getHandler(null).getStyle();
    }

    @Override
    public List<FontsDocument> getFontsDocument() throws Exception {
        return this.getHandler(null).getFontsDocument();
    }

    @Override
    public CTSettings getSettings() throws Exception {
        return this.getHandler(null).getSettings();
    }

    @Override
    public List<ThemeDocument> getThemeDocuments() throws Exception {
        return this.getHandler(null).getThemeDocuments();
    }

    @Override
    public FtrDocument getFtrDocumentByPartId(String relId) throws Exception {
        return this.getHandler(null).getFtrDocument(relId);
    }

    @Override
    public HdrDocument getHdrDocumentByPartId(String relId) throws Exception {
        return this.getHandler(null).getHdrDocument(relId);
    }

    private RelashionShipsHandler getHandler(String partName) throws SAXException, IOException {
        RelashionShipsHandler handler = this.handlers.get(partName = partName == null ? "document.xml" : this.getHandler(null).getRelationship((String)partName).target);
        if (handler == null) {
            handler = RelashionShipsHandler.create(partName, this);
            this.handlers.put(partName, handler);
        }
        return handler;
    }

    @Override
    public InputStream getInputStreamByRelId(String partName, String relId) throws Exception {
        return this.getHandler(partName).getInputStreamByRelId(relId);
    }

    protected abstract InputStream getEntryInputStream(String var1);
}

