/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.send;

import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.mariadb.jdbc.internal.packet.send.AbstractAuthSwitchSendResponsePacket;
import org.mariadb.jdbc.internal.packet.send.InterfaceAuthSwitchSendResponsePacket;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.Utils;

public class SendNativePasswordAuthPacket
extends AbstractAuthSwitchSendResponsePacket
implements InterfaceAuthSwitchSendResponsePacket {
    public SendNativePasswordAuthPacket(String password, byte[] authData, int packSeq, String passwordCharacterEncoding) {
        super(packSeq, authData, password, passwordCharacterEncoding);
    }

    @Override
    public void send(OutputStream os) throws IOException {
        PacketOutputStream writer = (PacketOutputStream)os;
        try {
            if (this.password == null || this.password.equals("")) {
                writer.writeEmptyPacket(this.packSeq);
                return;
            }
            writer.startPacket(this.packSeq);
            byte[] seed = this.authData.length > 0 ? Arrays.copyOfRange(this.authData, 0, this.authData.length - 1) : new byte[]{};
            writer.write(Utils.encryptPassword(this.password, seed, this.passwordCharacterEncoding));
            writer.finishPacketWithoutRelease(false);
            writer.releaseBuffer();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not use SHA-1, failing", e);
        }
    }
}

