/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.LongDataParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class StreamParameter
extends LongDataParameter {
    private static final int BUF_SIZE = 0x100004;
    private InputStream is;
    private long length;
    private boolean noBackslashEscapes;

    public StreamParameter(InputStream is, long length, boolean noBackslashEscapes) {
        this.is = is;
        this.length = length;
        this.noBackslashEscapes = noBackslashEscapes;
        if (is.markSupported()) {
            is.mark(1024);
        }
    }

    public StreamParameter(InputStream is, boolean noBackSlashEscapes) {
        this(is, Long.MAX_VALUE, noBackSlashEscapes);
    }

    @Override
    public void writeTo(PacketOutputStream os) throws IOException {
        if (this.length == Long.MAX_VALUE) {
            ParameterWriter.write((OutputStream)os, this.is, this.noBackslashEscapes);
        } else {
            ParameterWriter.write((OutputStream)os, this.is, this.length, this.noBackslashEscapes);
        }
    }

    @Override
    public void writeUnsafeTo(PacketOutputStream os) throws IOException {
        throw new IOException("Cannot use unsafe with Stream");
    }

    @Override
    public long getApproximateTextProtocolLength() throws IOException {
        return -1L;
    }

    @Override
    public void sendComLongData(int statementId, short parameterId, PacketOutputStream writer) throws IOException, QueryException {
        byte[] array = new byte[0x100004];
        if (this.length == Long.MAX_VALUE) {
            int len;
            while ((len = this.is.read(array, 6, 1048574)) > 0) {
                this.sendComPacket(statementId, parameterId, writer, array, len);
            }
        } else {
            int len;
            for (long remainingReadLength = this.length; remainingReadLength > 0L; remainingReadLength -= (long)len) {
                len = this.is.read(array, 6, Math.min((int)remainingReadLength, 1048574));
                if (len == -1) {
                    return;
                }
                this.sendComPacket(statementId, parameterId, writer, array, len);
            }
        }
    }

    private void sendComPacket(int statementId, short parameterId, PacketOutputStream writer, byte[] array, int len) throws IOException, QueryException {
        writer.startPacket(0);
        array[0] = (byte)(statementId & 0xFF);
        array[1] = (byte)(statementId >>> 8);
        array[2] = (byte)(statementId >>> 16);
        array[3] = (byte)(statementId >>> 24);
        array[4] = (byte)(parameterId & 0xFF);
        array[5] = (byte)(parameterId >>> 8);
        writer.sendDirect(array, 0, len + 6, (byte)24);
    }

    @Override
    public String toString() {
        try {
            if (this.is.markSupported()) {
                this.is.reset();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                if (this.length == Long.MAX_VALUE) {
                    ParameterWriter.write((OutputStream)baos, this.is, this.noBackslashEscapes);
                } else {
                    ParameterWriter.write((OutputStream)baos, this.is, this.length, this.noBackslashEscapes);
                }
                byte[] bytes = baos.toByteArray();
                if (bytes.length < 1024) {
                    return "<Stream:" + new String(bytes, StandardCharsets.UTF_8) + ">";
                }
                return "<Stream:" + new String(bytes, 0, 1024, StandardCharsets.UTF_8) + "...>";
            }
            return "<Stream>";
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.BLOB;
    }

    @Override
    public boolean isNullData() {
        return false;
    }
}

