/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.grails.datastore.gorm.query.criteria.DetachedAssociationCriteria;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.query.AssociationQuery;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.grails.datastore.mapping.query.criteria.FunctionCallingCriterion;
import org.grails.orm.hibernate.query.AbstractHibernateQuery;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;

public abstract class AbstractHibernateCriterionAdapter {
    protected static final Map<Class<?>, CriterionAdaptor<?>> criterionAdaptors = new HashMap();
    protected static boolean initialized;

    public AbstractHibernateCriterionAdapter() {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        if (initialized) {
            return;
        }
        Map<Class<?>, CriterionAdaptor<?>> map = criterionAdaptors;
        synchronized (map) {
            this.addSimplePropertyCriterionAdapters();
            this.addLikeCriterionAdapters();
            this.addSizeComparisonCriterionAdapters();
            this.addSimpleCriterionAdapters();
            this.addPropertyComparisonCriterionAdapters();
            this.addRangeQueryCriterionAdapters();
            this.addSubqueryCriterionAdapters();
            this.addJunctionCriterionAdapters();
            this.addAssociationQueryCriterionAdapters();
        }
        initialized = true;
    }

    protected void addSubqueryCriterionAdapters() {
        criterionAdaptors.put(Query.GreaterThanAll.class, new CriterionAdaptor<Query.GreaterThanAll>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.GreaterThanAll criterion, String alias) {
                QueryableCriteria subQuery = criterion.getValue();
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                DetachedCriteria detachedCriteria = AbstractHibernateCriterionAdapter.this.toHibernateDetachedCriteria(hibernateQuery, subQuery);
                return Property.forName((String)propertyName).gtAll(detachedCriteria);
            }
        });
        criterionAdaptors.put(Query.GreaterThanEqualsAll.class, new CriterionAdaptor<Query.GreaterThanEqualsAll>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.GreaterThanEqualsAll criterion, String alias) {
                DetachedCriteria detachedCriteria = AbstractHibernateCriterionAdapter.this.toHibernateDetachedCriteria(hibernateQuery, criterion.getValue());
                return Property.forName((String)AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias)).geAll(detachedCriteria);
            }
        });
        criterionAdaptors.put(Query.LessThanAll.class, new CriterionAdaptor<Query.LessThanAll>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.LessThanAll criterion, String alias) {
                DetachedCriteria detachedCriteria = AbstractHibernateCriterionAdapter.this.toHibernateDetachedCriteria(hibernateQuery, criterion.getValue());
                return Property.forName((String)AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias)).ltAll(detachedCriteria);
            }
        });
        criterionAdaptors.put(Query.LessThanEqualsAll.class, new CriterionAdaptor<Query.LessThanEqualsAll>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.LessThanEqualsAll criterion, String alias) {
                DetachedCriteria detachedCriteria = AbstractHibernateCriterionAdapter.this.toHibernateDetachedCriteria(hibernateQuery, criterion.getValue());
                return Property.forName((String)AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias)).leAll(detachedCriteria);
            }
        });
        criterionAdaptors.put(Query.GreaterThanSome.class, new CriterionAdaptor<Query.GreaterThanSome>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.GreaterThanSome criterion, String alias) {
                DetachedCriteria detachedCriteria = AbstractHibernateCriterionAdapter.this.toHibernateDetachedCriteria(hibernateQuery, criterion.getValue());
                return Property.forName((String)AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias)).gtSome(detachedCriteria);
            }
        });
        criterionAdaptors.put(Query.GreaterThanEqualsSome.class, new CriterionAdaptor<Query.GreaterThanEqualsSome>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.GreaterThanEqualsSome criterion, String alias) {
                DetachedCriteria detachedCriteria = AbstractHibernateCriterionAdapter.this.toHibernateDetachedCriteria(hibernateQuery, criterion.getValue());
                return Property.forName((String)AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias)).geSome(detachedCriteria);
            }
        });
        criterionAdaptors.put(Query.LessThanSome.class, new CriterionAdaptor<Query.LessThanSome>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.LessThanSome criterion, String alias) {
                DetachedCriteria detachedCriteria = AbstractHibernateCriterionAdapter.this.toHibernateDetachedCriteria(hibernateQuery, criterion.getValue());
                return Property.forName((String)AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias)).ltSome(detachedCriteria);
            }
        });
        criterionAdaptors.put(Query.LessThanEqualsSome.class, new CriterionAdaptor<Query.LessThanEqualsSome>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.LessThanEqualsSome criterion, String alias) {
                DetachedCriteria detachedCriteria = AbstractHibernateCriterionAdapter.this.toHibernateDetachedCriteria(hibernateQuery, criterion.getValue());
                return Property.forName((String)AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias)).leSome(detachedCriteria);
            }
        });
        criterionAdaptors.put(Query.NotIn.class, new CriterionAdaptor<Query.NotIn>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.NotIn criterion, String alias) {
                DetachedCriteria detachedCriteria = AbstractHibernateCriterionAdapter.this.toHibernateDetachedCriteria(hibernateQuery, criterion.getSubquery());
                return Property.forName((String)AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias)).notIn(detachedCriteria);
            }
        });
        criterionAdaptors.put(Query.Exists.class, new CriterionAdaptor<Query.Exists>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.Exists criterion, String alias) {
                DetachedCriteria detachedCriteria = AbstractHibernateCriterionAdapter.this.toHibernateDetachedCriteria(hibernateQuery, criterion.getSubquery());
                return Subqueries.exists((DetachedCriteria)detachedCriteria);
            }
        });
        criterionAdaptors.put(Query.NotExists.class, new CriterionAdaptor<Query.NotExists>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.NotExists criterion, String alias) {
                DetachedCriteria detachedCriteria = AbstractHibernateCriterionAdapter.this.toHibernateDetachedCriteria(hibernateQuery, criterion.getSubquery());
                return Subqueries.notExists((DetachedCriteria)detachedCriteria);
            }
        });
    }

    protected void addAssociationQueryCriterionAdapters() {
        criterionAdaptors.put(DetachedAssociationCriteria.class, new CriterionAdaptor(){

            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.Criterion criterion, String alias) {
                DetachedAssociationCriteria existing = (DetachedAssociationCriteria)criterion;
                if (alias == null) {
                    alias = existing.getAlias();
                }
                alias = hibernateQuery.handleAssociationQuery(existing.getAssociation(), existing.getCriteria(), alias);
                Conjunction conjunction = Restrictions.conjunction();
                AbstractHibernateCriterionAdapter.this.applySubCriteriaToJunction(existing.getAssociation().getAssociatedEntity(), hibernateQuery, existing.getCriteria(), (Junction)conjunction, alias);
                return conjunction;
            }
        });
        criterionAdaptors.put(AssociationQuery.class, new CriterionAdaptor(){

            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.Criterion criterion, String alias) {
                AssociationQuery existing = (AssociationQuery)criterion;
                Conjunction conjunction = Restrictions.conjunction();
                String newAlias = hibernateQuery.handleAssociationQuery(existing.getAssociation(), existing.getCriteria().getCriteria());
                alias = alias == null ? newAlias : alias + '.' + newAlias;
                AbstractHibernateCriterionAdapter.this.applySubCriteriaToJunction(existing.getAssociation().getAssociatedEntity(), hibernateQuery, existing.getCriteria().getCriteria(), (Junction)conjunction, alias);
                return conjunction;
            }
        });
    }

    protected void addJunctionCriterionAdapters() {
        criterionAdaptors.put(Query.Conjunction.class, new CriterionAdaptor<Query.Conjunction>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.Conjunction criterion, String alias) {
                Conjunction conjunction = Restrictions.conjunction();
                AbstractHibernateCriterionAdapter.this.applySubCriteriaToJunction(hibernateQuery.getEntity(), hibernateQuery, criterion.getCriteria(), (Junction)conjunction, alias);
                return conjunction;
            }
        });
        criterionAdaptors.put(Query.Disjunction.class, new CriterionAdaptor<Query.Disjunction>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.Disjunction criterion, String alias) {
                Disjunction disjunction = Restrictions.disjunction();
                AbstractHibernateCriterionAdapter.this.applySubCriteriaToJunction(hibernateQuery.getEntity(), hibernateQuery, criterion.getCriteria(), (Junction)disjunction, alias);
                return disjunction;
            }
        });
        criterionAdaptors.put(Query.Negation.class, new CriterionAdaptor<Query.Negation>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.Negation criterion, String alias) {
                CriterionAdaptor<?> adapter = criterionAdaptors.get(Query.Disjunction.class);
                return Restrictions.not((Criterion)adapter.toHibernateCriterion(hibernateQuery, new Query.Disjunction(criterion.getCriteria()), alias));
            }
        });
    }

    protected void addRangeQueryCriterionAdapters() {
        criterionAdaptors.put(Query.Between.class, new CriterionAdaptor(){

            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.Criterion criterion, String alias) {
                Query.Between btwCriterion = (Query.Between)criterion;
                return Restrictions.between((String)AbstractHibernateCriterionAdapter.this.calculatePropertyName(btwCriterion.getProperty(), alias), (Object)btwCriterion.getFrom(), (Object)btwCriterion.getTo());
            }
        });
        criterionAdaptors.put(Query.In.class, new CriterionAdaptor(){

            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.Criterion criterion, String alias) {
                Query.In inListQuery = (Query.In)criterion;
                QueryableCriteria subquery = inListQuery.getSubquery();
                if (subquery != null) {
                    return Property.forName((String)AbstractHibernateCriterionAdapter.this.getPropertyName(criterion, alias)).in(AbstractHibernateCriterionAdapter.this.toHibernateDetachedCriteria(hibernateQuery, subquery));
                }
                return Restrictions.in((String)AbstractHibernateCriterionAdapter.this.getPropertyName(criterion, alias), (Collection)inListQuery.getValues());
            }
        });
    }

    protected void addLikeCriterionAdapters() {
        criterionAdaptors.put(Query.RLike.class, new CriterionAdaptor(){

            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.Criterion criterion, String alias) {
                return AbstractHibernateCriterionAdapter.this.createRlikeExpression(AbstractHibernateCriterionAdapter.this.getPropertyName(criterion, alias), ((Query.RLike)criterion).getPattern());
            }
        });
        criterionAdaptors.put(Query.Like.class, new CriterionAdaptor<Query.Like>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.Like criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                Object value = criterion.getValue();
                return Restrictions.like((String)propertyName, (Object)value);
            }
        });
        criterionAdaptors.put(Query.ILike.class, new CriterionAdaptor<Query.ILike>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.ILike criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                Object value = criterion.getValue();
                return Restrictions.ilike((String)propertyName, (Object)value);
            }
        });
    }

    protected void addPropertyComparisonCriterionAdapters() {
        criterionAdaptors.put(Query.EqualsProperty.class, new CriterionAdaptor<Query.EqualsProperty>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.EqualsProperty criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                return Restrictions.eqProperty((String)propertyName, (String)criterion.getOtherProperty());
            }
        });
        criterionAdaptors.put(Query.GreaterThanProperty.class, new CriterionAdaptor<Query.GreaterThanProperty>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.GreaterThanProperty criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                return Restrictions.gtProperty((String)propertyName, (String)criterion.getOtherProperty());
            }
        });
        criterionAdaptors.put(Query.GreaterThanEqualsProperty.class, new CriterionAdaptor<Query.GreaterThanEqualsProperty>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.GreaterThanEqualsProperty criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                return Restrictions.geProperty((String)propertyName, (String)criterion.getOtherProperty());
            }
        });
        criterionAdaptors.put(Query.LessThanProperty.class, new CriterionAdaptor<Query.LessThanProperty>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.LessThanProperty criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                return Restrictions.ltProperty((String)propertyName, (String)criterion.getOtherProperty());
            }
        });
        criterionAdaptors.put(Query.LessThanEqualsProperty.class, new CriterionAdaptor<Query.LessThanEqualsProperty>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.LessThanEqualsProperty criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                return Restrictions.leProperty((String)propertyName, (String)criterion.getOtherProperty());
            }
        });
        criterionAdaptors.put(Query.NotEqualsProperty.class, new CriterionAdaptor<Query.NotEqualsProperty>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.NotEqualsProperty criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                return Restrictions.neProperty((String)propertyName, (String)criterion.getOtherProperty());
            }
        });
    }

    protected void addSimpleCriterionAdapters() {
        criterionAdaptors.put(Query.IsNull.class, new CriterionAdaptor<Query.IsNull>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.IsNull criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                return Restrictions.isNull((String)propertyName);
            }
        });
        criterionAdaptors.put(Query.IsNotNull.class, new CriterionAdaptor<Query.IsNotNull>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.IsNotNull criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                return Restrictions.isNotNull((String)propertyName);
            }
        });
        criterionAdaptors.put(Query.IsEmpty.class, new CriterionAdaptor<Query.IsEmpty>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.IsEmpty criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                return Restrictions.isEmpty((String)propertyName);
            }
        });
        criterionAdaptors.put(Query.IsNotEmpty.class, new CriterionAdaptor<Query.IsNotEmpty>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.IsNotEmpty criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                return Restrictions.isNotEmpty((String)propertyName);
            }
        });
    }

    protected void addSizeComparisonCriterionAdapters() {
        criterionAdaptors.put(Query.SizeEquals.class, new CriterionAdaptor<Query.SizeEquals>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.SizeEquals criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                Object value = criterion.getValue();
                int size = value instanceof Number ? ((Number)value).intValue() : Integer.parseInt(value.toString());
                return Restrictions.sizeEq((String)propertyName, (int)size);
            }
        });
        criterionAdaptors.put(Query.SizeGreaterThan.class, new CriterionAdaptor<Query.SizeGreaterThan>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.SizeGreaterThan criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                Object value = criterion.getValue();
                int size = value instanceof Number ? ((Number)value).intValue() : Integer.parseInt(value.toString());
                return Restrictions.sizeGt((String)propertyName, (int)size);
            }
        });
        criterionAdaptors.put(Query.SizeGreaterThanEquals.class, new CriterionAdaptor<Query.SizeGreaterThanEquals>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.SizeGreaterThanEquals criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                Object value = criterion.getValue();
                int size = value instanceof Number ? ((Number)value).intValue() : Integer.parseInt(value.toString());
                return Restrictions.sizeGe((String)propertyName, (int)size);
            }
        });
        criterionAdaptors.put(Query.SizeLessThan.class, new CriterionAdaptor<Query.SizeLessThan>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.SizeLessThan criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                Object value = criterion.getValue();
                int size = value instanceof Number ? ((Number)value).intValue() : Integer.parseInt(value.toString());
                return Restrictions.sizeLt((String)propertyName, (int)size);
            }
        });
        criterionAdaptors.put(Query.SizeLessThanEquals.class, new CriterionAdaptor<Query.SizeLessThanEquals>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.SizeLessThanEquals criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                Object value = criterion.getValue();
                int size = value instanceof Number ? ((Number)value).intValue() : Integer.parseInt(value.toString());
                return Restrictions.sizeLe((String)propertyName, (int)size);
            }
        });
    }

    protected void addSimplePropertyCriterionAdapters() {
        criterionAdaptors.put(Query.IdEquals.class, new CriterionAdaptor(){

            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.Criterion criterion, String alias) {
                return Restrictions.idEq((Object)((Query.IdEquals)criterion).getValue());
            }
        });
        criterionAdaptors.put(Query.Equals.class, new CriterionAdaptor<Query.Equals>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.Equals criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                Object value = criterion.getValue();
                if (value instanceof DetachedCriteria) {
                    return Property.forName((String)propertyName).eq((DetachedCriteria)value);
                }
                return Restrictions.eq((String)propertyName, (Object)value);
            }
        });
        criterionAdaptors.put(Query.NotEquals.class, new CriterionAdaptor<Query.NotEquals>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.NotEquals criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                Object value = criterion.getValue();
                if (value instanceof DetachedCriteria) {
                    return Property.forName((String)propertyName).ne((DetachedCriteria)value);
                }
                return Restrictions.ne((String)propertyName, (Object)value);
            }
        });
        criterionAdaptors.put(Query.GreaterThan.class, new CriterionAdaptor<Query.GreaterThan>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.GreaterThan criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                Object value = criterion.getValue();
                if (value instanceof DetachedCriteria) {
                    return Property.forName((String)propertyName).gt((DetachedCriteria)value);
                }
                return Restrictions.gt((String)propertyName, (Object)value);
            }
        });
        criterionAdaptors.put(Query.GreaterThanEquals.class, new CriterionAdaptor<Query.GreaterThanEquals>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.GreaterThanEquals criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                Object value = criterion.getValue();
                if (value instanceof DetachedCriteria) {
                    return Property.forName((String)propertyName).ge((DetachedCriteria)value);
                }
                return Restrictions.ge((String)propertyName, (Object)value);
            }
        });
        criterionAdaptors.put(Query.LessThan.class, new CriterionAdaptor<Query.LessThan>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.LessThan criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                Object value = criterion.getValue();
                if (value instanceof DetachedCriteria) {
                    return Property.forName((String)propertyName).lt((DetachedCriteria)value);
                }
                return Restrictions.lt((String)propertyName, (Object)value);
            }
        });
        criterionAdaptors.put(Query.LessThanEquals.class, new CriterionAdaptor<Query.LessThanEquals>(){

            @Override
            public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.LessThanEquals criterion, String alias) {
                String propertyName = AbstractHibernateCriterionAdapter.this.getPropertyName((Query.Criterion)criterion, alias);
                Object value = criterion.getValue();
                if (value instanceof DetachedCriteria) {
                    return Property.forName((String)propertyName).le((DetachedCriteria)value);
                }
                return Restrictions.le((String)propertyName, (Object)value);
            }
        });
    }

    protected abstract Criterion createRlikeExpression(String var1, String var2);

    protected String getPropertyName(Query.Criterion criterion, String alias) {
        return this.calculatePropertyName(((Query.PropertyNameCriterion)criterion).getProperty(), alias);
    }

    protected String calculatePropertyName(String property, String alias) {
        if (alias != null) {
            return alias + '.' + property;
        }
        return property;
    }

    protected void applySubCriteriaToJunction(PersistentEntity entity, AbstractHibernateQuery hibernateCriteria, List<Query.Criterion> existing, Junction conjunction, String alias) {
        for (Query.Criterion subCriterion : existing) {
            Criterion sqlRestriction;
            CriterionAdaptor<?> criterionAdaptor;
            if (subCriterion instanceof Query.PropertyCriterion) {
                Query.PropertyCriterion pc = (Query.PropertyCriterion)subCriterion;
                if (pc.getValue() instanceof QueryableCriteria) {
                    pc.setValue((Object)this.toHibernateDetachedCriteria(hibernateCriteria, (QueryableCriteria)pc.getValue()));
                } else {
                    AbstractHibernateQuery.doTypeConversionIfNeccessary(entity, pc);
                }
            }
            if ((criterionAdaptor = criterionAdaptors.get(subCriterion.getClass())) != null) {
                Criterion c = criterionAdaptor.toHibernateCriterion(hibernateCriteria, subCriterion, alias);
                if (c == null) continue;
                conjunction.add(c);
                continue;
            }
            if (!(subCriterion instanceof FunctionCallingCriterion) || (sqlRestriction = hibernateCriteria.getRestrictionForFunctionCall((FunctionCallingCriterion)subCriterion, entity)) == null) continue;
            conjunction.add(sqlRestriction);
        }
    }

    public Criterion toHibernateCriterion(AbstractHibernateQuery hibernateQuery, Query.Criterion criterion, String alias) {
        CriterionAdaptor<?> criterionAdaptor = criterionAdaptors.get(criterion.getClass());
        if (criterionAdaptor != null) {
            return criterionAdaptor.toHibernateCriterion(hibernateQuery, criterion, alias);
        }
        return null;
    }

    protected abstract DetachedCriteria toHibernateDetachedCriteria(AbstractHibernateQuery var1, QueryableCriteria<?> var2);

    public static abstract class CriterionAdaptor<T extends Query.Criterion> {
        public abstract Criterion toHibernateCriterion(AbstractHibernateQuery var1, T var2, String var3);

        protected Object convertStringValue(Object o) {
            if (!(o instanceof String) && o instanceof CharSequence) {
                o = o.toString();
            }
            return o;
        }
    }
}

