/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.utils;

import fr.opensagres.xdocreport.core.io.IEntryInfo;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.cache.ITemplateCacheInfoProvider;
import fr.opensagres.xdocreport.template.internal.DynamicBean;

public class TemplateUtils {
    public static String getCachedTemplateName(String reportId, String entryName) {
        StringBuilder templateName = new StringBuilder(reportId);
        templateName.append('!');
        templateName.append(entryName);
        return templateName.toString();
    }

    public static int getIndexReportEntryName(String cachedTemplateName) {
        return cachedTemplateName.lastIndexOf(33);
    }

    public static String getReportId(String cachedTemplateName, int index) {
        return cachedTemplateName.substring(0, index);
    }

    public static String getEntryName(String cachedTemplateName, int index) {
        return cachedTemplateName.substring(index + 1, cachedTemplateName.length());
    }

    public static IEntryInfo getTemplateCacheInfo(ITemplateCacheInfoProvider templateCacheInfoProvider, String templateName) {
        if (templateCacheInfoProvider == null) {
            return null;
        }
        int index = TemplateUtils.getIndexReportEntryName(templateName);
        if (index == -1) {
            return null;
        }
        String reportId = TemplateUtils.getReportId(templateName, index);
        String entryName = TemplateUtils.getEntryName(templateName, index);
        return templateCacheInfoProvider.getTemplateCacheInfo(reportId, entryName);
    }

    public static Object putContextForDottedKey(IContext context, String key, Object value) {
        int index = key.indexOf(46);
        if (index != -1) {
            String[] keys = key.split("[.]");
            String newKey = keys[0];
            DynamicBean bean = TemplateUtils.getDynamicBean(context, newKey);
            if (bean != null) {
                bean.setValue(keys, value, 1);
            }
            return bean;
        }
        return null;
    }

    private static DynamicBean getDynamicBean(IContext context, String key) {
        Object result = context.get(key);
        if (result == null) {
            DynamicBean bean = new DynamicBean();
            context.put(key, bean);
            return bean;
        }
        if (result instanceof DynamicBean) {
            return (DynamicBean)result;
        }
        return null;
    }
}

