/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.ps.PSImageFormResource;
import org.apache.fop.render.ps.PSImageHandler;
import org.apache.fop.render.ps.PSRenderingContext;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;
import org.apache.xmlgraphics.ps.ImageEncoder;
import org.apache.xmlgraphics.ps.ImageEncodingHelper;
import org.apache.xmlgraphics.ps.ImageFormGenerator;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSImageUtils;

public class PSImageHandlerRenderedImage
implements PSImageHandler {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.BUFFERED_IMAGE, ImageFlavor.RENDERED_IMAGE};

    @Override
    public void handleImage(RenderingContext context, org.apache.xmlgraphics.image.loader.Image image, Rectangle pos) throws IOException {
        PSRenderingContext psContext = (PSRenderingContext)context;
        PSGenerator gen = psContext.getGenerator();
        ImageRendered imageRend = (ImageRendered)image;
        float x = (float)pos.getX() / 1000.0f;
        float y = (float)pos.getY() / 1000.0f;
        float w = (float)pos.getWidth() / 1000.0f;
        float h = (float)pos.getHeight() / 1000.0f;
        Rectangle2D.Double targetRect = new Rectangle2D.Double(x, y, w, h);
        RenderedImage ri = imageRend.getRenderedImage();
        if (ri instanceof BufferedImage && ri.getColorModel().hasAlpha()) {
            BufferedImage convertedImg = new BufferedImage(ri.getWidth(), ri.getHeight(), 1);
            Graphics2D g = (Graphics2D)convertedImg.getGraphics();
            g.setBackground(Color.WHITE);
            g.clearRect(0, 0, ri.getWidth(), ri.getHeight());
            g.drawImage((Image)((BufferedImage)ri), 0, 0, null);
            g.dispose();
            ri = convertedImg;
        }
        ImageEncoder encoder = ImageEncodingHelper.createRenderedImageEncoder((RenderedImage)ri);
        Dimension imgDim = new Dimension(ri.getWidth(), ri.getHeight());
        String imgDescription = ri.getClass().getName();
        ImageEncodingHelper helper = new ImageEncodingHelper(ri);
        ColorModel cm = helper.getEncodedColorModel();
        PSImageUtils.writeImage((ImageEncoder)encoder, (Dimension)imgDim, (String)imgDescription, (Rectangle2D)targetRect, (ColorModel)cm, (PSGenerator)gen, (RenderedImage)ri);
    }

    @Override
    public void generateForm(RenderingContext context, org.apache.xmlgraphics.image.loader.Image image, PSImageFormResource form) throws IOException {
        PSRenderingContext psContext = (PSRenderingContext)context;
        PSGenerator gen = psContext.getGenerator();
        ImageRendered imageRend = (ImageRendered)image;
        ImageInfo info = image.getInfo();
        String imageDescription = info.getMimeType() + " " + info.getOriginalURI();
        RenderedImage ri = imageRend.getRenderedImage();
        ImageFormGenerator formGen = new ImageFormGenerator(form.getName(), imageDescription, info.getSize().getDimensionPt(), ri, false);
        formGen.generate(gen);
    }

    @Override
    public int getPriority() {
        return 300;
    }

    @Override
    public Class getSupportedImageClass() {
        return ImageRendered.class;
    }

    @Override
    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    @Override
    public boolean isCompatible(RenderingContext targetContext, org.apache.xmlgraphics.image.loader.Image image) {
        return (image == null || image instanceof ImageRendered) && targetContext instanceof PSRenderingContext;
    }
}

