/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor.sax.contenttypes;

import fr.opensagres.xdocreport.core.document.ImageFormat;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.numbering.NumberingRegistry;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedDocumentContentHandler;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DocxContentTypesDocumentContentHandler
extends BufferedDocumentContentHandler {
    private static final String TYPES_ELT = "Types";
    private static final String DEFAULT_ELT = "Default";
    private static final String EXTENSION_ATTR = "Extension";
    private static final String OVERRIDE_ELT = "Override";
    private List<ImageFormat> missingFormats = new ArrayList<ImageFormat>();
    protected final String entryName;
    protected final IDocumentFormatter formatter;
    protected final FieldsMetadata fieldsMetadata;
    private boolean hasNumbering;

    public DocxContentTypesDocumentContentHandler(String entryName, FieldsMetadata fieldsMetadata, IDocumentFormatter formatter, Map<String, Object> sharedContext) {
        this.entryName = entryName;
        this.formatter = formatter;
        this.fieldsMetadata = fieldsMetadata;
        this.hasNumbering = false;
    }

    public void startDocument() throws SAXException {
        ImageFormat format = null;
        ImageFormat[] formats = ImageFormat.values();
        for (int i = 0; i < formats.length; ++i) {
            format = formats[i];
            this.missingFormats.add(format);
        }
        super.startDocument();
    }

    public boolean doStartElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (DEFAULT_ELT.equals(name)) {
            ImageFormat format = ImageFormat.getFormatByExtension((String)attributes.getValue(EXTENSION_ATTR));
            if (format != null) {
                this.missingFormats.remove(format);
            }
        } else if (OVERRIDE_ELT.equals(name) && !this.hasNumbering) {
            this.hasNumbering = "/word/numbering.xml".equals(attributes.getValue("PartName"));
        }
        return super.doStartElement(uri, localName, name, attributes);
    }

    public void doEndElement(String uri, String localName, String name) throws SAXException {
        if (TYPES_ELT.equals(name)) {
            for (ImageFormat format : this.missingFormats) {
                BufferedElement currentRegion = this.getCurrentElement();
                currentRegion.append("<Default Extension=\"");
                currentRegion.append(format.name());
                currentRegion.append("\" ContentType=\"image/");
                currentRegion.append(format.getType());
                currentRegion.append("\" />");
            }
            if (!this.hasNumbering && NumberingRegistry.hasDynamicNumbering(this.fieldsMetadata)) {
                BufferedElement currentRegion = this.getCurrentElement();
                currentRegion.append("<Override PartName=\"/word/numbering.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml\" />");
            }
        }
        super.doEndElement(uri, localName, name);
    }
}

