/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.util.Locale;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.LoggersEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.ActuatorGetMapping;
import org.springframework.boot.actuate.endpoint.mvc.ActuatorPostMapping;
import org.springframework.boot.actuate.endpoint.mvc.EndpointMvcAdapter;
import org.springframework.boot.actuate.endpoint.mvc.HypermediaDisabled;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.logging.LogLevel;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ConfigurationProperties(prefix="endpoints.loggers")
public class LoggersMvcEndpoint
extends EndpointMvcAdapter {
    private final LoggersEndpoint delegate;

    public LoggersMvcEndpoint(LoggersEndpoint delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @ActuatorGetMapping(value={"/{name:.*}"})
    @ResponseBody
    @HypermediaDisabled
    public Object get(@PathVariable String name) {
        if (!this.delegate.isEnabled()) {
            return this.getDisabledResponse();
        }
        LoggersEndpoint.LoggerLevels levels = this.delegate.invoke(name);
        return levels != null ? levels : ResponseEntity.notFound().build();
    }

    @ActuatorPostMapping(value={"/{name:.*}"})
    @ResponseBody
    @HypermediaDisabled
    public Object set(@PathVariable String name, @RequestBody Map<String, String> configuration) {
        if (!this.delegate.isEnabled()) {
            return this.getDisabledResponse();
        }
        LogLevel logLevel = this.getLogLevel(configuration);
        this.delegate.setLogLevel(name, logLevel);
        return ResponseEntity.ok().build();
    }

    private LogLevel getLogLevel(Map<String, String> configuration) {
        String level = configuration.get("configuredLevel");
        try {
            return level != null ? LogLevel.valueOf((String)level.toUpperCase(Locale.ENGLISH)) : null;
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidLogLevelException(level);
        }
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST, reason="No such log level")
    public static class InvalidLogLevelException
    extends RuntimeException {
        public InvalidLogLevelException(String level) {
            super("Log level '" + level + "' is invalid");
        }
    }
}

