/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.xhtml.extension;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public abstract class AbstractContentBuffer {
    protected final int indent;

    public AbstractContentBuffer(int indent) {
        this.indent = indent;
    }

    public void setText(String content) {
        this.getCurrentBuffer().append(content);
    }

    protected void doIndentIfNeeded(StringBuilder buffer, int index) {
        if (this.indent > 0) {
            buffer.append("\n");
            for (int i = 0; i < index; ++i) {
                for (int j = 0; j < this.indent; ++j) {
                    buffer.append(' ');
                }
            }
        }
    }

    protected void doIndentIfNeeded(OutputStream out, int index) throws IOException {
        if (this.indent > 0) {
            out.write(10);
            for (int i = 0; i < index; ++i) {
                for (int j = 0; j < this.indent; ++j) {
                    out.write(32);
                }
            }
        }
    }

    protected void doIndentIfNeeded(Writer writer, int index) throws IOException {
        if (this.indent > 0) {
            writer.write(10);
            for (int i = 0; i < index; ++i) {
                for (int j = 0; j < this.indent; ++j) {
                    writer.write(32);
                }
            }
        }
    }

    protected abstract StringBuilder getCurrentBuffer();
}

