/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

public class XmlNameUtil {
    public static String descapeXmlTypeName(String name) {
        StringBuilder sb = new StringBuilder();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                if (i == len - 1) {
                    XmlNameUtil.writeChar(sb, c);
                    continue;
                }
                if (name.charAt(i + 1) == 'x') {
                    String hex = name.substring(i + 2, i + 6);
                    XmlNameUtil.writeChar(sb, XmlNameUtil.descape(hex));
                    i += 6;
                    continue;
                }
                XmlNameUtil.writeChar(sb, c);
                continue;
            }
            XmlNameUtil.writeChar(sb, c);
        }
        return sb.toString();
    }

    public static String escapeXmlTypeName(String name) {
        StringBuilder sb = new StringBuilder();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z') {
                XmlNameUtil.writeChar(sb, c);
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                XmlNameUtil.writeChar(sb, c);
                continue;
            }
            if (c == '_') {
                if (i == len - 1) {
                    XmlNameUtil.writeChar(sb, c);
                    continue;
                }
                if (name.charAt(i + 1) == 'x') {
                    XmlNameUtil.escapeChar(sb, c);
                    continue;
                }
                XmlNameUtil.writeChar(sb, c);
                continue;
            }
            if (c > '\u007f') {
                XmlNameUtil.escapeChar(sb, c);
                continue;
            }
            if (c >= '0' && c <= '9') {
                if (i > 0) {
                    XmlNameUtil.writeChar(sb, c);
                    continue;
                }
                XmlNameUtil.escapeChar(sb, c);
                continue;
            }
            if (c == '.' || c == '-') {
                if (i > 0) {
                    XmlNameUtil.writeChar(sb, c);
                    continue;
                }
                XmlNameUtil.escapeChar(sb, c);
                continue;
            }
            XmlNameUtil.escapeChar(sb, c);
        }
        return sb.toString();
    }

    private static void writeChar(StringBuilder sb, char c) {
        sb.append(c);
    }

    private static void escapeChar(StringBuilder sb, char c) {
        sb.append("_x" + String.format("%04x", c) + "_");
    }

    private static char descape(String hexString) {
        int value = Integer.parseInt(hexString, 16);
        return (char)value;
    }
}

