/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.shared.spi;

import java.util.Comparator;
import java.util.Properties;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserVersionType;
import org.jadira.usertype.dateandtime.shared.spi.AbstractSingleColumnUserType;
import org.jadira.usertype.dateandtime.shared.spi.Seed;
import org.jadira.usertype.dateandtime.shared.spi.VersionableColumnMapper;

public abstract class AbstractVersionableUserType<T, J, C extends VersionableColumnMapper<T, J>>
extends AbstractSingleColumnUserType<T, J, C>
implements UserVersionType,
Comparator,
ParameterizedType {
    private static final long serialVersionUID = -491420480137454209L;
    private Seed<J> seed;

    public void setParameterValues(Properties parameters) {
        if (parameters != null) {
            String seedName = parameters.getProperty("seed");
            if (seedName != null) {
                Class<?> seedClass;
                try {
                    Class<?> mySeedClass;
                    seedClass = mySeedClass = Class.forName(seedName);
                }
                catch (ClassNotFoundException ex) {
                    throw new IllegalStateException("Referenced seed class {" + seedName + "} cannot be found");
                }
                try {
                    this.seed = (Seed)seedClass.newInstance();
                }
                catch (InstantiationException ex) {
                    throw new IllegalStateException("Referenced seed class {" + seedName + "} cannot be instantiated");
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Referenced seed class {" + seedName + "} cannot be accessed");
                }
            }
        } else {
            this.seed = null;
        }
    }

    public abstract int compare(Object var1, Object var2);

    public T seed(SessionImplementor session) {
        VersionableColumnMapper columnMapper = (VersionableColumnMapper)this.getColumnMapper();
        if (this.seed == null) {
            return columnMapper.fromNonNullValue(columnMapper.generateCurrentValue());
        }
        return columnMapper.fromNonNullValue(this.seed.getTimestamp(session));
    }

    public T next(Object current, SessionImplementor session) {
        return this.seed(session);
    }
}

