/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core.openxmlformats.styles.table;

import fr.opensagres.poi.xwpf.converter.core.openxmlformats.styles.table.AbstractTableValueProvider;
import fr.opensagres.poi.xwpf.converter.core.styles.XWPFStylesDocument;
import fr.opensagres.poi.xwpf.converter.core.utils.DxaUtil;
import fr.opensagres.poi.xwpf.converter.core.utils.XWPFTableUtil;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPrBase;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;

public class TableIndentationValueProvider
extends AbstractTableValueProvider<Float> {
    public static final TableIndentationValueProvider INSTANCE = new TableIndentationValueProvider();

    @Override
    public Float getValue(CTTblPr tblPr, XWPFStylesDocument document) {
        return this.getTableAlignment((CTTblPrBase)tblPr);
    }

    @Override
    public Float getValue(CTTblPrBase tblPr, XWPFStylesDocument document) {
        return this.getTableAlignment(tblPr);
    }

    private Float getTableAlignment(CTTblPrBase tblPr) {
        if (tblPr == null) {
            return null;
        }
        CTTblWidth tblWidth = tblPr.getTblInd();
        if (tblWidth != null) {
            Float width;
            STTblWidth.Enum type = tblWidth.getType();
            if (type != null) {
                // empty if block
            }
            if ((width = XWPFTableUtil.getTblWidthW(tblWidth)) != null) {
                return Float.valueOf(DxaUtil.dxa2points(width.floatValue()));
            }
        }
        return null;
    }
}

