/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrawingPropsIdTracker {
    protected static Logger log = LoggerFactory.getLogger(DrawingPropsIdTracker.class);
    private Set<JaxbXmlPart> jaxbXmlParts = new HashSet<JaxbXmlPart>();
    private Set<Long> usedIds = new HashSet<Long>();
    private long lastDispensed = 1L;
    List<JaxbXmlPart> markedForDereg = new ArrayList<JaxbXmlPart>();

    public void registerPart(Part part) {
        if (part instanceof JaxbXmlPart) {
            this.jaxbXmlParts.add((JaxbXmlPart)part);
        }
    }

    public void deregisterPart(Part part) {
        if (part instanceof JaxbXmlPart) {
            this.markedForDereg.add((JaxbXmlPart)part);
        }
    }

    public void registerId(long num) {
        if (this.usedIds.add(num)) {
            log.debug("registering docPr/@id " + num);
        } else {
            log.debug("already present? docPr/@id " + num);
        }
    }

    public long generateId() throws Docx4JException {
        if (!this.jaxbXmlParts.isEmpty()) {
            for (JaxbXmlPart jaxbXmlPart : this.jaxbXmlParts) {
                jaxbXmlPart.getContents();
                this.markedForDereg.add(jaxbXmlPart);
            }
            this.jaxbXmlParts.clear();
        }
        long newId = this.lastDispensed + 1L;
        while (this.usedIds.contains(newId)) {
            ++newId;
        }
        this.lastDispensed = newId;
        this.usedIds.add(newId);
        return newId;
    }
}

