/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.validation.BootstrapConfiguration;
import javax.validation.executable.ExecutableType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.validation.Schema;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetClassLoader;
import org.hibernate.validator.internal.util.privilegedactions.NewJaxbContext;
import org.hibernate.validator.internal.util.privilegedactions.SetContextClassLoader;
import org.hibernate.validator.internal.util.privilegedactions.Unmarshal;
import org.hibernate.validator.internal.xml.BootstrapConfigurationImpl;
import org.hibernate.validator.internal.xml.DefaultValidatedExecutableTypesType;
import org.hibernate.validator.internal.xml.ExecutableValidationType;
import org.hibernate.validator.internal.xml.PropertyType;
import org.hibernate.validator.internal.xml.ResourceLoaderHelper;
import org.hibernate.validator.internal.xml.ValidationConfigType;
import org.hibernate.validator.internal.xml.XmlParserHelper;

public class ValidationXmlParser {
    private static final Log log = LoggerFactory.make();
    private static final String VALIDATION_XML_FILE = "META-INF/validation.xml";
    private static final ConcurrentMap<String, String> SCHEMAS_BY_VERSION = new ConcurrentHashMap<String, String>(2, 0.75f, 1);
    private final ClassLoader externalClassLoader;

    public ValidationXmlParser(ClassLoader externalClassLoader) {
        this.externalClassLoader = externalClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BootstrapConfiguration parseValidationXml() {
        InputStream inputStream = this.getValidationXmlInputStream();
        if (inputStream == null) {
            return BootstrapConfigurationImpl.getDefaultBootstrapConfiguration();
        }
        ClassLoader previousTccl = ValidationXmlParser.run(GetClassLoader.fromContext());
        try {
            ValidationXmlParser.run(SetContextClassLoader.action(ValidationXmlParser.class.getClassLoader()));
            XmlParserHelper xmlParserHelper = new XmlParserHelper();
            XMLEventReader xmlEventReader = xmlParserHelper.createXmlEventReader(VALIDATION_XML_FILE, inputStream);
            String schemaVersion = xmlParserHelper.getSchemaVersion(VALIDATION_XML_FILE, xmlEventReader);
            Schema schema = this.getSchema(xmlParserHelper, schemaVersion);
            ValidationConfigType validationConfig = this.unmarshal(xmlEventReader, schema);
            BootstrapConfiguration bootstrapConfiguration = this.createBootstrapConfiguration(validationConfig);
            return bootstrapConfiguration;
        }
        finally {
            ValidationXmlParser.run(SetContextClassLoader.action(previousTccl));
            this.closeStream(inputStream);
        }
    }

    private InputStream getValidationXmlInputStream() {
        log.debugf("Trying to load %s for XML based Validator configuration.", VALIDATION_XML_FILE);
        InputStream inputStream = ResourceLoaderHelper.getResettableInputStreamForPath(VALIDATION_XML_FILE, this.externalClassLoader);
        if (inputStream != null) {
            return inputStream;
        }
        log.debugf("No %s found. Using annotation based configuration only.", VALIDATION_XML_FILE);
        return null;
    }

    private Schema getSchema(XmlParserHelper xmlParserHelper, String schemaVersion) {
        String schemaResource = (String)SCHEMAS_BY_VERSION.get(schemaVersion);
        if (schemaResource == null) {
            throw log.getUnsupportedSchemaVersionException(VALIDATION_XML_FILE, schemaVersion);
        }
        return xmlParserHelper.getSchema(schemaResource);
    }

    private ValidationConfigType unmarshal(XMLEventReader xmlEventReader, Schema schema) {
        log.parsingXMLFile(VALIDATION_XML_FILE);
        try {
            JAXBContext jc = this.run(NewJaxbContext.action(ValidationConfigType.class));
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            JAXBElement root = (JAXBElement)this.run(Unmarshal.action(unmarshaller, xmlEventReader, ValidationConfigType.class));
            return (ValidationConfigType)root.getValue();
        }
        catch (Exception e) {
            throw log.getUnableToParseValidationXmlFileException(VALIDATION_XML_FILE, e);
        }
    }

    private void closeStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException io) {
            log.unableToCloseXMLFileInputStream(VALIDATION_XML_FILE);
        }
    }

    private BootstrapConfiguration createBootstrapConfiguration(ValidationConfigType config) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (PropertyType property : config.getProperty()) {
            if (log.isDebugEnabled()) {
                log.debugf("Found property '%s' with value '%s' in validation.xml.", property.getName(), property.getValue());
            }
            properties.put(property.getName(), property.getValue());
        }
        ExecutableValidationType executableValidationType = config.getExecutableValidation();
        EnumSet<ExecutableType> defaultValidatedExecutableTypes = executableValidationType == null ? this.getValidatedExecutableTypes(null) : this.getValidatedExecutableTypes(executableValidationType.getDefaultValidatedExecutableTypes());
        boolean executableValidationEnabled = executableValidationType == null || executableValidationType.getEnabled() != false;
        return new BootstrapConfigurationImpl(config.getDefaultProvider(), config.getConstraintValidatorFactory(), config.getMessageInterpolator(), config.getTraversableResolver(), config.getParameterNameProvider(), defaultValidatedExecutableTypes, executableValidationEnabled, new HashSet<String>(config.getConstraintMapping()), properties);
    }

    private EnumSet<ExecutableType> getValidatedExecutableTypes(DefaultValidatedExecutableTypesType validatedExecutables) {
        if (validatedExecutables == null) {
            return null;
        }
        EnumSet<ExecutableType> executableTypes = EnumSet.noneOf(ExecutableType.class);
        executableTypes.addAll(validatedExecutables.getExecutableType());
        return executableTypes;
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    private <T> T run(PrivilegedExceptionAction<T> action) throws Exception {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    static {
        SCHEMAS_BY_VERSION.put("1.0", "META-INF/validation-configuration-1.0.xsd");
        SCHEMAS_BY_VERSION.put("1.1", "META-INF/validation-configuration-1.1.xsd");
    }
}

