/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.util;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SampleRateUtils {
    public static boolean isValidSampleRate(@Nullable Double sampleRate) {
        return SampleRateUtils.isValidRate(sampleRate, true);
    }

    public static boolean isValidTracesSampleRate(@Nullable Double tracesSampleRate) {
        return SampleRateUtils.isValidTracesSampleRate(tracesSampleRate, true);
    }

    public static boolean isValidTracesSampleRate(@Nullable Double tracesSampleRate, boolean allowNull) {
        return SampleRateUtils.isValidRate(tracesSampleRate, allowNull);
    }

    public static boolean isValidProfilesSampleRate(@Nullable Double profilesSampleRate) {
        return SampleRateUtils.isValidRate(profilesSampleRate, true);
    }

    private static boolean isValidRate(@Nullable Double rate, boolean allowNull) {
        if (rate == null) {
            return allowNull;
        }
        return !rate.isNaN() && rate >= 0.0 && rate <= 1.0;
    }
}

