/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.LongDataParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class ReaderParameter
extends LongDataParameter {
    private static final int BUF_SIZE = 0x100004;
    private static final int CHAR_BUF_SIZE = 4096;
    private Reader reader;
    private long length;
    private boolean noBackslashEscapes;

    public ReaderParameter(Reader reader, long length, boolean noBackslashEscapes) {
        this.reader = reader;
        this.length = length;
        this.noBackslashEscapes = noBackslashEscapes;
        if (reader.markSupported()) {
            try {
                reader.mark(1024);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public ReaderParameter(Reader reader, boolean noBackslashEscapes) {
        this(reader, Long.MAX_VALUE, noBackslashEscapes);
    }

    @Override
    public void writeTo(PacketOutputStream os) throws IOException {
        if (this.length == Long.MAX_VALUE) {
            ParameterWriter.write((OutputStream)os, this.reader, this.noBackslashEscapes);
        } else {
            ParameterWriter.write((OutputStream)os, this.reader, this.length, this.noBackslashEscapes);
        }
    }

    @Override
    public void writeUnsafeTo(PacketOutputStream os) throws IOException {
        throw new IOException("Cannot use unsafe with Reader");
    }

    @Override
    public long getApproximateTextProtocolLength() throws IOException {
        return -1L;
    }

    @Override
    public void sendComLongData(int statementId, short parameterId, PacketOutputStream writer) throws IOException, QueryException {
        byte[] arr = new byte[0x100004];
        char[] charBuffer = new char[4096];
        long remainingReadLength = this.length;
        while (remainingReadLength > 0L) {
            byte[] bytes;
            writer.startPacket(0);
            arr[0] = (byte)(statementId & 0xFF);
            arr[1] = (byte)(statementId >>> 8);
            arr[2] = (byte)(statementId >>> 16);
            arr[3] = (byte)(statementId >>> 24);
            arr[4] = (byte)(parameterId & 0xFF);
            arr[5] = (byte)(parameterId >>> 8);
            int position = 6;
            int len = 0;
            if (this.length == Long.MAX_VALUE) {
                while (position + 12288 < 0x100004 && (len = this.reader.read(charBuffer)) > 0) {
                    bytes = new String(charBuffer, 0, len).getBytes("UTF-8");
                    System.arraycopy(bytes, 0, arr, position, bytes.length);
                    position += bytes.length;
                }
            } else {
                while (position + 12288 < 0x100004 && (len = this.reader.read(charBuffer, 0, Math.min((int)remainingReadLength, 4096))) > 0) {
                    bytes = new String(charBuffer, 0, len).getBytes("UTF-8");
                    System.arraycopy(bytes, 0, arr, position, bytes.length);
                    position += bytes.length;
                    remainingReadLength -= (long)len;
                }
            }
            if (position > 6) {
                writer.sendDirect(arr, 0, position, (byte)24);
                continue;
            }
            if (len != -1) continue;
            break;
        }
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.STRING;
    }

    @Override
    public String toString() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (this.reader.markSupported()) {
                this.reader.reset();
            }
            if (this.length == Long.MAX_VALUE) {
                ParameterWriter.write((OutputStream)baos, this.reader, this.noBackslashEscapes);
            } else {
                ParameterWriter.write((OutputStream)baos, this.reader, this.length, this.noBackslashEscapes);
            }
            byte[] bytes = baos.toByteArray();
            if (bytes.length < 1024) {
                return "<Buffer:" + new String(bytes, StandardCharsets.UTF_8) + ">";
            }
            return "<Buffer:" + new String(bytes, 0, 1024, StandardCharsets.UTF_8) + "...>";
        }
        catch (Exception e) {
            return "";
        }
    }
}

