/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.common;

import com.p6spy.engine.common.ConnectionInformation;
import com.p6spy.engine.common.PreparedStatementInformation;
import com.p6spy.engine.common.Value;
import java.util.HashMap;
import java.util.Map;

public class CallableStatementInformation
extends PreparedStatementInformation {
    private final Map<String, Value> namedParameterValues = new HashMap<String, Value>();

    public CallableStatementInformation(ConnectionInformation connectionInformation, String query) {
        super(connectionInformation, query);
    }

    @Override
    public String getSqlWithValues() {
        if (this.namedParameterValues.size() == 0) {
            return super.getSqlWithValues();
        }
        StringBuilder result = new StringBuilder();
        String statementQuery = this.getStatementQuery();
        result.append(statementQuery);
        result.append(" ");
        StringBuilder parameters = new StringBuilder();
        for (Map.Entry<Integer, Value> entry : this.getParameterValues().entrySet()) {
            this.appendParameter(parameters, entry.getKey().toString(), entry.getValue());
        }
        for (Map.Entry<Object, Value> entry : this.namedParameterValues.entrySet()) {
            this.appendParameter(parameters, (String)entry.getKey(), entry.getValue());
        }
        result.append((CharSequence)parameters);
        return result.toString();
    }

    private void appendParameter(StringBuilder parameters, String name, Value value) {
        if (parameters.length() > 0) {
            parameters.append(", ");
        }
        parameters.append(name);
        parameters.append(":");
        parameters.append(value != null ? value.toString() : new Value().toString());
    }

    public void setParameterValue(String name, Object value) {
        this.namedParameterValues.put(name, new Value(value));
    }
}

