/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor.sax.notes;

import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.notes.NoteInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NoteRegistry {
    public static final String REGISTER_NOTE_METHOD = "registerNote";
    public static final String GET_NOTES_METHOD = "getNotes";
    private Map<String, List<NoteInfo>> notesMap;

    public String registerNote(String id, Object content) throws XDocReportException, IOException {
        List<NoteInfo> footnotes;
        if (this.notesMap == null) {
            this.notesMap = new HashMap<String, List<NoteInfo>>();
        }
        if ((footnotes = this.notesMap.get(id)) == null) {
            footnotes = new ArrayList<NoteInfo>();
            this.notesMap.put(id, footnotes);
        }
        String newId = "" + this.createNewId();
        footnotes.add(new NoteInfo(newId, content != null ? content.toString() : ""));
        return newId;
    }

    public List<NoteInfo> getNotes(String id) {
        if (this.notesMap == null) {
            return Collections.emptyList();
        }
        List<NoteInfo> footnotes = this.notesMap.get(id);
        if (footnotes == null) {
            return Collections.emptyList();
        }
        return footnotes;
    }

    private int createNewId() {
        int result = 1;
        for (List<NoteInfo> elements : this.notesMap.values()) {
            result += elements.size();
        }
        return result;
    }
}

