/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.IHub;
import io.sentry.Sentry;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class SentryWrapper {
    public static <U> Callable<U> wrapCallable(@NotNull Callable<U> callable) {
        IHub oldState = Sentry.getCurrentHub();
        IHub newHub = oldState.clone();
        return () -> {
            Sentry.setCurrentHub(newHub);
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                Sentry.setCurrentHub(oldState);
            }
        };
    }

    public static <U> Supplier<U> wrapSupplier(@NotNull Supplier<U> supplier) {
        IHub oldState = Sentry.getCurrentHub();
        IHub newHub = oldState.clone();
        return () -> {
            Sentry.setCurrentHub(newHub);
            try {
                Object t = supplier.get();
                return t;
            }
            finally {
                Sentry.setCurrentHub(oldState);
            }
        };
    }
}

