/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.query;

import java.util.HashMap;
import java.util.Map;
import org.grails.datastore.mapping.query.Query;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;

public class HibernateProjectionAdapter {
    private Query.Projection projection;
    private static Map<Class<?>, ProjectionAdapter> adapterMap = new HashMap();

    public HibernateProjectionAdapter(Query.Projection projection) {
        this.projection = projection;
    }

    public Projection toHibernateProjection() {
        ProjectionAdapter projectionAdapter = adapterMap.get(this.projection.getClass());
        if (projectionAdapter == null) {
            throw new UnsupportedOperationException("Unsupported projection used: " + this.projection.getClass().getName());
        }
        return projectionAdapter.toHibernateProjection(this.projection);
    }

    static {
        adapterMap.put(Query.AvgProjection.class, new ProjectionAdapter(){

            @Override
            public Projection toHibernateProjection(Query.Projection gormProjection) {
                Query.AvgProjection avg = (Query.AvgProjection)gormProjection;
                return Projections.avg((String)avg.getPropertyName());
            }
        });
        adapterMap.put(Query.IdProjection.class, new ProjectionAdapter(){

            @Override
            public Projection toHibernateProjection(Query.Projection gormProjection) {
                return Projections.id();
            }
        });
        adapterMap.put(Query.SumProjection.class, new ProjectionAdapter(){

            @Override
            public Projection toHibernateProjection(Query.Projection gormProjection) {
                Query.SumProjection avg = (Query.SumProjection)gormProjection;
                return Projections.sum((String)avg.getPropertyName());
            }
        });
        adapterMap.put(Query.DistinctPropertyProjection.class, new ProjectionAdapter(){

            @Override
            public Projection toHibernateProjection(Query.Projection gormProjection) {
                Query.DistinctPropertyProjection avg = (Query.DistinctPropertyProjection)gormProjection;
                return Projections.distinct((Projection)Projections.property((String)avg.getPropertyName()));
            }
        });
        adapterMap.put(Query.PropertyProjection.class, new ProjectionAdapter(){

            @Override
            public Projection toHibernateProjection(Query.Projection gormProjection) {
                Query.PropertyProjection avg = (Query.PropertyProjection)gormProjection;
                return Projections.property((String)avg.getPropertyName());
            }
        });
        adapterMap.put(Query.CountProjection.class, new ProjectionAdapter(){

            @Override
            public Projection toHibernateProjection(Query.Projection gormProjection) {
                return Projections.rowCount();
            }
        });
        adapterMap.put(Query.CountDistinctProjection.class, new ProjectionAdapter(){

            @Override
            public Projection toHibernateProjection(Query.Projection gormProjection) {
                Query.CountDistinctProjection cd = (Query.CountDistinctProjection)gormProjection;
                return Projections.countDistinct((String)cd.getPropertyName());
            }
        });
        adapterMap.put(Query.GroupPropertyProjection.class, new ProjectionAdapter(){

            @Override
            public Projection toHibernateProjection(Query.Projection gormProjection) {
                Query.GroupPropertyProjection cd = (Query.GroupPropertyProjection)gormProjection;
                return Projections.groupProperty((String)cd.getPropertyName());
            }
        });
        adapterMap.put(Query.MaxProjection.class, new ProjectionAdapter(){

            @Override
            public Projection toHibernateProjection(Query.Projection gormProjection) {
                Query.MaxProjection cd = (Query.MaxProjection)gormProjection;
                return Projections.max((String)cd.getPropertyName());
            }
        });
        adapterMap.put(Query.MinProjection.class, new ProjectionAdapter(){

            @Override
            public Projection toHibernateProjection(Query.Projection gormProjection) {
                Query.MinProjection cd = (Query.MinProjection)gormProjection;
                return Projections.min((String)cd.getPropertyName());
            }
        });
    }

    private static interface ProjectionAdapter {
        public Projection toHibernateProjection(Query.Projection var1);
    }
}

