/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot;

import java.util.Map;

public class CachedRow {
    private Map row;

    public CachedRow(Map row) {
        this.row = row;
    }

    public Object get(String columnName) {
        return this.row.get(columnName);
    }

    public void set(String columnName, Object value) {
        this.row.put(columnName, value);
    }

    public boolean containsColumn(String columnName) {
        return this.row.containsKey(columnName);
    }

    public String getString(String columnName) {
        return (String)this.row.get(columnName);
    }

    public Integer getInt(String columnName) {
        Object o2 = this.row.get(columnName);
        if (o2 instanceof Number) {
            return ((Number)o2).intValue();
        }
        if (o2 instanceof String) {
            return Integer.valueOf((String)o2);
        }
        return (Integer)o2;
    }

    public Short getShort(String columnName) {
        Object o2 = this.row.get(columnName);
        if (o2 instanceof Number) {
            return ((Number)o2).shortValue();
        }
        if (o2 instanceof String) {
            return Short.valueOf((String)o2);
        }
        return (Short)o2;
    }

    public Boolean getBoolean(String columnName) {
        Object o2 = this.row.get(columnName);
        if (o2 instanceof Number) {
            if (((Number)o2).longValue() == 0L) {
                return false;
            }
            return true;
        }
        if (o2 instanceof String) {
            String s2 = (String)o2;
            if ("T".equalsIgnoreCase(s2)) {
                s2 = "TRUE";
            }
            return Boolean.valueOf(s2);
        }
        return (Boolean)o2;
    }

    public Boolean yesNoToBoolean(String columnName) {
        Object o2 = this.row.get(columnName);
        if (o2 instanceof String && "YES".equalsIgnoreCase((String)o2)) {
            return Boolean.TRUE;
        }
        return this.getBoolean(columnName);
    }
}

