/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.snapshot;

import java.util.Iterator;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.snapshot.HibernateSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Relation;
import liquibase.structure.core.UniqueConstraint;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;

public class IndexSnapshotGenerator
extends HibernateSnapshotGenerator {
    public IndexSnapshotGenerator() {
        super(liquibase.structure.core.Index.class, new Class[]{liquibase.structure.core.Table.class, ForeignKey.class, UniqueConstraint.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (example.getSnapshotId() != null) {
            return example;
        }
        Relation table = ((liquibase.structure.core.Index)example).getRelation();
        Table hibernateTable = this.findHibernateTable((DatabaseObject)table, snapshot);
        if (hibernateTable == null) {
            return example;
        }
        Iterator indexIterator = hibernateTable.getIndexIterator();
        while (indexIterator.hasNext()) {
            Index hibernateIndex = (Index)indexIterator.next();
            liquibase.structure.core.Index index = new liquibase.structure.core.Index();
            index.setRelation(table);
            index.setName(hibernateIndex.getName());
            index.setUnique(this.isUniqueIndex(hibernateIndex));
            Iterator columnIterator = hibernateIndex.getColumnIterator();
            while (columnIterator.hasNext()) {
                Column hibernateColumn = (Column)columnIterator.next();
                index.getColumns().add(new liquibase.structure.core.Column(hibernateColumn.getName()).setRelation(table));
            }
            if (!index.getColumnNames().equalsIgnoreCase(((liquibase.structure.core.Index)example).getColumnNames())) continue;
            LOG.info("Found index " + index.getName());
            table.getIndexes().add(index);
            return index;
        }
        return example;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(liquibase.structure.core.Index.class)) {
            return;
        }
        if (foundObject instanceof liquibase.structure.core.Table) {
            liquibase.structure.core.Table table = (liquibase.structure.core.Table)foundObject;
            Table hibernateTable = this.findHibernateTable((DatabaseObject)table, snapshot);
            if (hibernateTable == null) {
                return;
            }
            Iterator indexIterator = hibernateTable.getIndexIterator();
            while (indexIterator.hasNext()) {
                Index hibernateIndex = (Index)indexIterator.next();
                liquibase.structure.core.Index index = new liquibase.structure.core.Index();
                index.setRelation((Relation)table);
                index.setName(hibernateIndex.getName());
                index.setUnique(this.isUniqueIndex(hibernateIndex));
                Iterator columnIterator = hibernateIndex.getColumnIterator();
                while (columnIterator.hasNext()) {
                    Column hibernateColumn = (Column)columnIterator.next();
                    index.getColumns().add(new liquibase.structure.core.Column(hibernateColumn.getName()).setRelation((Relation)table));
                }
                LOG.info("Found index " + index.getName());
                table.getIndexes().add(index);
            }
        }
    }

    private Boolean isUniqueIndex(Index hibernateIndex) {
        if (hibernateIndex.getColumnSpan() == 1) {
            Column col = (Column)hibernateIndex.getColumnIterator().next();
            return col.isUnique();
        }
        return false;
    }
}

