/*
 * Decompiled with CFR 0.152.
 */
package grails.plugins.quartz;

import grails.plugins.quartz.StringEditor;
import java.beans.PropertyEditor;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.quartz.impl.triggers.AbstractTrigger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class CustomTriggerFactoryBean
implements FactoryBean<Trigger>,
InitializingBean {
    private Class<Trigger> triggerClass;
    private Trigger customTrigger;
    private JobDetail jobDetail;
    private Map triggerAttributes;

    public void afterPropertiesSet() throws ParseException {
        this.customTrigger = (Trigger)BeanUtils.instantiateClass(this.triggerClass);
        if (this.customTrigger instanceof AbstractTrigger) {
            AbstractTrigger at = (AbstractTrigger)this.customTrigger;
            if (this.jobDetail != null) {
                at.setJobKey(this.jobDetail.getKey());
            }
            if (this.triggerAttributes.containsKey("startDelay")) {
                Number startDelay = (Number)this.triggerAttributes.remove("startDelay");
                at.setStartTime(new Date(System.currentTimeMillis() + startDelay.longValue()));
            } else {
                at.setStartTime(new Date());
            }
        }
        BeanWrapper customTriggerWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)this.customTrigger);
        customTriggerWrapper.registerCustomEditor(String.class, (PropertyEditor)new StringEditor());
        customTriggerWrapper.setPropertyValues(this.triggerAttributes);
    }

    public Trigger getObject() throws Exception {
        return this.customTrigger;
    }

    public Class<? extends Trigger> getObjectType() {
        return this.triggerClass;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setJobDetail(JobDetail jobDetail) {
        this.jobDetail = jobDetail;
    }

    public void setTriggerClass(Class<Trigger> triggerClass) {
        this.triggerClass = triggerClass;
    }

    public void setTriggerAttributes(Map triggerAttributes) {
        this.triggerAttributes = triggerAttributes;
    }
}

