/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.change;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.storedlogic.trigger.change.DropTriggerStatement;
import com.datical.liquibase.ext.util.RefactoringUtils;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropTrigger", description="Drop trigger", priority=1)
public class DropTriggerChange
extends LicenseValidationChange {
    private String triggerName;
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String scope;

    @Override
    public ValidationErrors validate(Database database) {
        if (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof AbstractDb2Database || database instanceof PostgresDatabase) {
            return super.validate(database);
        }
        return RefactoringUtils.createValidationErrors(database, this);
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String string) {
        this.triggerName = string;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String string) {
        this.catalogName = string;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String string) {
        this.scope = string;
    }

    @Override
    public String getConfirmationMessage() {
        return "Trigger" + this.getTriggerName() + " has been dropped";
    }

    @Override
    public SqlStatement[] generateStatements(Database object) {
        object = new DropTriggerStatement(this.getCatalogName(), this.getSchemaName(), this.getTriggerName());
        ((DropTriggerStatement)object).setScope(this.getScope());
        ((DropTriggerStatement)object).setTableName(this.getTableName());
        return new SqlStatement[]{object};
    }
}

