/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.send.gssapi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.mariadb.jdbc.internal.packet.read.ReadPacketFetcher;
import org.mariadb.jdbc.internal.packet.send.gssapi.GssapiAuth;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.buffer.Buffer;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class StandardGssapiAuthentication
extends GssapiAuth {
    public StandardGssapiAuthentication(ReadPacketFetcher packetFetcher, int packSeq) {
        super(packetFetcher, packSeq);
    }

    @Override
    public void authenticate(final PacketOutputStream writer, final String serverPrincipalName, String mechanisms) throws QueryException, IOException {
        block9: {
            if ("".equals(serverPrincipalName)) {
                throw new QueryException("No principal name defined on server. Please set server variable \"gssapi-principal-name\"", 0, "28000");
            }
            if (System.getProperty("java.security.auth.login.config") == null) {
                File jaasConfFile;
                try {
                    jaasConfFile = File.createTempFile("jaas.conf", null);
                    PrintStream bos = new PrintStream(new FileOutputStream(jaasConfFile));
                    bos.print(String.format("Krb5ConnectorContext {\ncom.sun.security.auth.module.Krb5LoginModule required useTicketCache=true debug=true renewTGT=true doNotPrompt=true; };", new Object[0]));
                    bos.close();
                    jaasConfFile.deleteOnExit();
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                System.setProperty("java.security.auth.login.config", jaasConfFile.getCanonicalPath());
            }
            try {
                LoginContext loginContext = new LoginContext("Krb5ConnectorContext");
                loginContext.login();
                Subject mySubject = loginContext.getSubject();
                if (!mySubject.getPrincipals().isEmpty()) {
                    try {
                        PrivilegedExceptionAction<Void> action = new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws Exception {
                                try {
                                    Oid krb5Mechanism = new Oid("1.2.840.113554.1.2.2");
                                    GSSManager manager = GSSManager.getInstance();
                                    GSSName peerName = manager.createName(serverPrincipalName, GSSName.NT_USER_NAME);
                                    GSSContext context = manager.createContext(peerName, krb5Mechanism, null, 0);
                                    context.requestMutualAuth(true);
                                    byte[] inToken = new byte[]{};
                                    while (!context.isEstablished()) {
                                        byte[] outToken = context.initSecContext(inToken, 0, inToken.length);
                                        if (outToken != null) {
                                            writer.startPacket(StandardGssapiAuthentication.this.packSeq);
                                            writer.write(outToken);
                                            writer.finishPacketWithoutRelease(false);
                                            writer.releaseBuffer();
                                        }
                                        if (context.isEstablished()) continue;
                                        Buffer buffer = StandardGssapiAuthentication.this.packetFetcher.getReusableBuffer();
                                        StandardGssapiAuthentication.this.packSeq = StandardGssapiAuthentication.this.packetFetcher.getLastPacketSeq() + 1;
                                        inToken = buffer.readRawBytes(buffer.remaining());
                                    }
                                }
                                catch (GSSException le) {
                                    throw new QueryException("GSS-API authentication exception", 1045, "28000", (Throwable)le);
                                }
                                return null;
                            }
                        };
                        Subject.doAs(mySubject, action);
                        break block9;
                    }
                    catch (PrivilegedActionException exception) {
                        throw new QueryException("GSS-API authentication exception", 1045, "28000", (Throwable)exception);
                    }
                }
                throw new QueryException("GSS-API authentication exception : no credential cache not found.", 0, "28000");
            }
            catch (LoginException le) {
                throw new QueryException("GSS-API authentication exception", 1045, "28000", (Throwable)le);
            }
        }
    }
}

