/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.proxy;

import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import java.io.Serializable;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.engine.AssociationQueryExecutor;
import org.grails.datastore.mapping.proxy.JavassistProxyFactory;
import org.grails.datastore.mapping.proxy.ProxyFactory;
import org.grails.datastore.mapping.proxy.ProxyHandler;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.HibernateProxyHelper;
import org.hibernate.proxy.LazyInitializer;

public class SimpleHibernateProxyHandler
extends JavassistProxyFactory
implements ProxyHandler,
ProxyFactory {
    public boolean isInitialized(Object o) {
        if (o instanceof HibernateProxy) {
            return !((HibernateProxy)o).getHibernateLazyInitializer().isUninitialized();
        }
        if (o instanceof PersistentCollection) {
            return ((PersistentCollection)o).wasInitialized();
        }
        return super.isInitialized(o);
    }

    public boolean isInitialized(Object obj, String associationName) {
        try {
            Object proxy = ClassPropertyFetcher.getInstancePropertyValue((Object)obj, (String)associationName);
            return this.isInitialized(proxy);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public Object unwrap(Object object) {
        return this.unwrapIfProxy(object);
    }

    public Serializable getIdentifier(Object obj) {
        return (Serializable)this.getProxyIdentifier(obj);
    }

    public Object unwrapIfProxy(Object instance) {
        if (instance instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)instance;
            return this.unwrapProxy(proxy);
        }
        return super.unwrap(instance);
    }

    public Object unwrapProxy(HibernateProxy proxy) {
        Object obj;
        LazyInitializer lazyInitializer = proxy.getHibernateLazyInitializer();
        if (lazyInitializer.isUninitialized()) {
            lazyInitializer.initialize();
        }
        if ((obj = lazyInitializer.getImplementation()) != null) {
            SimpleHibernateProxyHandler.ensureCorrectGroovyMetaClass(obj, obj.getClass());
        }
        return obj;
    }

    private static void ensureCorrectGroovyMetaClass(Object target, Class<?> persistentClass) {
        GroovyObject go;
        if (target instanceof GroovyObject && !(go = (GroovyObject)target).getMetaClass().getTheClass().equals(persistentClass)) {
            go.setMetaClass(GroovySystem.getMetaClassRegistry().getMetaClass(persistentClass));
        }
    }

    public HibernateProxy getAssociationProxy(Object obj, String associationName) {
        try {
            Object proxy = ClassPropertyFetcher.getInstancePropertyValue((Object)obj, (String)associationName);
            if (proxy instanceof HibernateProxy) {
                return (HibernateProxy)proxy;
            }
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public boolean isProxy(Object o) {
        return o instanceof HibernateProxy || super.isProxy(o);
    }

    public void initialize(Object o) {
        if (o instanceof HibernateProxy) {
            LazyInitializer hibernateLazyInitializer = ((HibernateProxy)o).getHibernateLazyInitializer();
            if (hibernateLazyInitializer.isUninitialized()) {
                hibernateLazyInitializer.initialize();
            }
        } else {
            super.initialize(o);
        }
    }

    public Object getProxyIdentifier(Object o) {
        if (o instanceof HibernateProxy) {
            return ((HibernateProxy)o).getHibernateLazyInitializer().getIdentifier();
        }
        return super.getIdentifier(o);
    }

    public Class<?> getProxiedClass(Object o) {
        if (o instanceof HibernateProxy) {
            return HibernateProxyHelper.getClassWithoutInitializingProxy((Object)o);
        }
        return super.getProxiedClass(o);
    }

    public <T> T createProxy(Session session, Class<T> type, Serializable key) {
        return (T)super.createProxy(session, type, key);
    }

    public <T, K extends Serializable> T createProxy(Session session, AssociationQueryExecutor<K, T> executor, K associationKey) {
        return (T)super.createProxy(session, executor, associationKey);
    }
}

