/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document;

import fr.opensagres.xdocreport.converter.Options;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.dispatcher.IXDocReportController;
import fr.opensagres.xdocreport.document.dispatcher.IXDocReportLoader;
import fr.opensagres.xdocreport.document.registry.XDocReportRegistry;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public class XDocReport {
    public static IXDocReport generateReport(String reportId, IXDocReportController controller, Map<String, Object> contextMap, OutputStream out) throws IOException, XDocReportException {
        return XDocReport.generateReport(reportId, controller, contextMap, out, XDocReport.getDefaultRegistry());
    }

    public static IXDocReport generateReport(String reportId, IXDocReportController controller, Map<String, Object> contextMap, OutputStream out, XDocReportRegistry registry) throws IOException, XDocReportException {
        IXDocReport report = XDocReport.getReport(reportId, controller, registry);
        report.process(contextMap, out);
        return report;
    }

    public static IXDocReport generateReportAndConvert(String reportId, IXDocReportController controller, Map<String, Object> contextMap, Options options, OutputStream out) throws IOException, XDocReportException {
        return XDocReport.generateReportAndConvert(reportId, controller, contextMap, options, out, XDocReport.getDefaultRegistry());
    }

    public static IXDocReport generateReportAndConvert(String reportId, IXDocReportController controller, Map<String, Object> contextMap, Options options, OutputStream out, XDocReportRegistry registry) throws IOException, XDocReportException {
        IXDocReport report = XDocReport.getReport(reportId, controller, registry);
        report.convert(contextMap, options, out);
        return report;
    }

    public static IXDocReport getReport(String reportId, IXDocReportController controller) throws IOException, XDocReportException {
        XDocReportRegistry registry = XDocReport.getDefaultRegistry();
        return XDocReport.getReport(reportId, controller, registry);
    }

    public static IXDocReport getReport(String reportId, IXDocReportController controller, XDocReportRegistry registry) throws IOException, XDocReportException {
        IXDocReport report = registry.getReport(reportId);
        if (report != null) {
            return report;
        }
        return XDocReport.loadReport(reportId, controller, registry);
    }

    public static IXDocReport loadReport(String reportId, IXDocReportController controller, XDocReportRegistry registry) throws IOException, XDocReportException {
        InputStream sourceStream = controller.getSourceStream();
        if (sourceStream == null) {
            throw new XDocReportException("Input stream is null with reportId=" + reportId);
        }
        String templateEngineKind = controller.getTemplateEngineKind();
        IXDocReport report = registry.loadReport(sourceStream, reportId, templateEngineKind);
        report.setFieldsMetadata(controller.getFieldsMetadata());
        return report;
    }

    public static IXDocReport generateReport(String reportId, IXDocReportLoader reportLoader, Map<String, Object> contextMap, OutputStream out) throws IOException, XDocReportException {
        return XDocReport.generateReport(reportId, reportLoader, contextMap, out, XDocReport.getDefaultRegistry());
    }

    public static IXDocReport generateReport(String reportId, IXDocReportLoader reportLoader, Map<String, Object> contextMap, OutputStream out, XDocReportRegistry registry) throws IOException, XDocReportException {
        IXDocReport report = XDocReport.getReport(reportId, reportLoader, registry);
        report.process(contextMap, out);
        return report;
    }

    public static IXDocReport generateReportAndConvert(String reportId, IXDocReportLoader reportLoader, Map<String, Object> contextMap, Options options, OutputStream out) throws IOException, XDocReportException {
        return XDocReport.generateReportAndConvert(reportId, reportLoader, contextMap, options, out, XDocReport.getDefaultRegistry());
    }

    public static IXDocReport generateReportAndConvert(String reportId, IXDocReportLoader reportLoader, Map<String, Object> contextMap, Options options, OutputStream out, XDocReportRegistry registry) throws IOException, XDocReportException {
        IXDocReport report = XDocReport.getReport(reportId, reportLoader, registry);
        report.convert(contextMap, options, out);
        return report;
    }

    public static IXDocReport getReport(String reportId, IXDocReportLoader reportLoader) throws IOException, XDocReportException {
        XDocReportRegistry registry = XDocReport.getDefaultRegistry();
        return XDocReport.getReport(reportId, reportLoader, registry);
    }

    public static IXDocReport getReport(String reportId, IXDocReportLoader reportLoader, XDocReportRegistry registry) throws IOException, XDocReportException {
        IXDocReport report = registry.getReport(reportId);
        if (report != null) {
            return report;
        }
        return XDocReport.loadReport(reportId, reportLoader, registry);
    }

    public static IXDocReport loadReport(String reportId, IXDocReportLoader reportLoader, XDocReportRegistry registry) throws IOException, XDocReportException {
        InputStream sourceStream = reportLoader.getSourceStream(reportId);
        if (sourceStream == null) {
            throw new XDocReportException("Input stream is null with reportId=" + reportId);
        }
        String templateEngineKind = reportLoader.getTemplateEngineKind(reportId);
        IXDocReport report = registry.loadReport(sourceStream, reportId, templateEngineKind);
        report.setFieldsMetadata(reportLoader.getFieldsMetadata(reportId));
        return report;
    }

    public static IXDocReport generateReport(InputStream sourceStream, String templateEngineKind, FieldsMetadata metadata, Map<String, Object> contextMap, OutputStream out) throws XDocReportException, IOException {
        return XDocReport.generateReport(sourceStream, templateEngineKind, metadata, contextMap, out, XDocReport.getDefaultRegistry());
    }

    public static IXDocReport generateReport(InputStream sourceStream, String templateEngineKind, FieldsMetadata metadata, Map<String, Object> contextMap, OutputStream out, XDocReportRegistry registry) throws XDocReportException, IOException {
        if (sourceStream == null) {
            throw new XDocReportException("Input stream is null");
        }
        IXDocReport report = XDocReport.loadReport(sourceStream, templateEngineKind, metadata, registry);
        report.process(contextMap, out);
        return report;
    }

    public static IXDocReport generateReportAndConvert(InputStream sourceStream, String templateEngineKind, FieldsMetadata metadata, Map<String, Object> contextMap, Options options, OutputStream out) throws IOException, XDocReportException {
        return XDocReport.generateReportAndConvert(sourceStream, templateEngineKind, metadata, contextMap, options, out, XDocReport.getDefaultRegistry());
    }

    public static IXDocReport generateReportAndConvert(InputStream sourceStream, String templateEngineKind, FieldsMetadata metadata, Map<String, Object> contextMap, Options options, OutputStream out, XDocReportRegistry registry) throws IOException, XDocReportException {
        IXDocReport report = XDocReport.loadReport(sourceStream, templateEngineKind, metadata, registry);
        report.convert(contextMap, options, out);
        return report;
    }

    public static IXDocReport loadReport(InputStream sourceStream, String templateEngineKind, FieldsMetadata metadata, XDocReportRegistry registry) throws IOException, XDocReportException {
        if (sourceStream == null) {
            throw new XDocReportException("Input stream is null ");
        }
        IXDocReport report = registry.loadReport(sourceStream, null, templateEngineKind, false);
        report.setFieldsMetadata(metadata);
        return report;
    }

    private static XDocReportRegistry getDefaultRegistry() {
        return XDocReportRegistry.getRegistry();
    }
}

