/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate;

import grails.gorm.multitenancy.Tenants;
import groovy.lang.Closure;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Callable;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import org.grails.datastore.gorm.events.AutoTimestampEventListener;
import org.grails.datastore.gorm.jdbc.schema.DefaultSchemaHandler;
import org.grails.datastore.gorm.jdbc.schema.SchemaHandler;
import org.grails.datastore.gorm.validation.registry.support.ValidatorRegistries;
import org.grails.datastore.mapping.config.Settings;
import org.grails.datastore.mapping.core.AbstractDatastore;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.DatastoreAware;
import org.grails.datastore.mapping.core.connections.ConnectionSource;
import org.grails.datastore.mapping.core.connections.ConnectionSourceSettings;
import org.grails.datastore.mapping.core.connections.ConnectionSources;
import org.grails.datastore.mapping.core.connections.MultipleConnectionSourceCapableDatastore;
import org.grails.datastore.mapping.core.connections.SingletonConnectionSources;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.multitenancy.AllTenantsResolver;
import org.grails.datastore.mapping.multitenancy.MultiTenancySettings;
import org.grails.datastore.mapping.multitenancy.MultiTenantCapableDatastore;
import org.grails.datastore.mapping.multitenancy.SchemaMultiTenantCapableDatastore;
import org.grails.datastore.mapping.multitenancy.TenantResolver;
import org.grails.datastore.mapping.multitenancy.exceptions.TenantNotFoundException;
import org.grails.datastore.mapping.multitenancy.resolvers.FixedTenantResolver;
import org.grails.datastore.mapping.transactions.TransactionCapableDatastore;
import org.grails.datastore.mapping.validation.ValidatorRegistry;
import org.grails.orm.hibernate.AbstractHibernateGormInstanceApi;
import org.grails.orm.hibernate.IHibernateTemplate;
import org.grails.orm.hibernate.cfg.HibernateMappingContext;
import org.grails.orm.hibernate.connections.HibernateConnectionSource;
import org.grails.orm.hibernate.connections.HibernateConnectionSourceSettings;
import org.grails.orm.hibernate.event.listener.AbstractHibernateEventListener;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.core.env.PropertyResolver;

public abstract class AbstractHibernateDatastore
extends AbstractDatastore
implements ApplicationContextAware,
Settings,
SchemaMultiTenantCapableDatastore<SessionFactory, HibernateConnectionSourceSettings>,
TransactionCapableDatastore,
Closeable,
MessageSourceAware,
MultipleConnectionSourceCapableDatastore {
    public static final String CONFIG_PROPERTY_CACHE_QUERIES = "grails.hibernate.cache.queries";
    public static final String CONFIG_PROPERTY_OSIV_READONLY = "grails.hibernate.osiv.readonly";
    public static final String CONFIG_PROPERTY_PASS_READONLY_TO_HIBERNATE = "grails.hibernate.pass.readonly";
    protected final SessionFactory sessionFactory;
    protected final ConnectionSources<SessionFactory, HibernateConnectionSourceSettings> connectionSources;
    protected final String defaultFlushModeName;
    protected final MultiTenancySettings.MultiTenancyMode multiTenantMode;
    protected final SchemaHandler schemaHandler;
    protected AbstractHibernateEventListener eventTriggeringInterceptor;
    protected AutoTimestampEventListener autoTimestampEventListener;
    protected final boolean osivReadOnly;
    protected final boolean passReadOnlyToHibernate;
    protected final boolean isCacheQueries;
    protected final int defaultFlushMode;
    protected final boolean failOnError;
    protected final boolean markDirty;
    protected final String dataSourceName;
    protected final TenantResolver tenantResolver;
    private boolean destroyed;

    protected AbstractHibernateDatastore(ConnectionSources<SessionFactory, HibernateConnectionSourceSettings> connectionSources, HibernateMappingContext mappingContext) {
        super((MappingContext)mappingContext, connectionSources.getBaseConfiguration(), null);
        this.connectionSources = connectionSources;
        HibernateConnectionSource defaultConnectionSource = (HibernateConnectionSource)connectionSources.getDefaultConnectionSource();
        this.dataSourceName = defaultConnectionSource.getName();
        this.sessionFactory = (SessionFactory)defaultConnectionSource.getSource();
        HibernateConnectionSourceSettings settings = (HibernateConnectionSourceSettings)defaultConnectionSource.getSettings();
        HibernateConnectionSourceSettings.HibernateSettings hibernateSettings = settings.getHibernate();
        this.osivReadOnly = hibernateSettings.getOsiv().isReadonly();
        this.passReadOnlyToHibernate = hibernateSettings.isReadOnly();
        this.isCacheQueries = hibernateSettings.getCache().isQueries();
        this.failOnError = settings.isFailOnError();
        Boolean markDirty = settings.getMarkDirty();
        this.markDirty = markDirty == null ? false : markDirty;
        FlushMode flushMode = FlushMode.valueOf(hibernateSettings.getFlush().getMode().name());
        this.defaultFlushModeName = flushMode.name();
        this.defaultFlushMode = flushMode.getLevel();
        MultiTenancySettings multiTenancySettings = settings.getMultiTenancy();
        TenantResolver multiTenantResolver = multiTenancySettings.getTenantResolver();
        this.multiTenantMode = multiTenancySettings.getMode();
        Class schemaHandlerClass = settings.getDataSource().getSchemaHandler();
        this.schemaHandler = (SchemaHandler)BeanUtils.instantiate((Class)schemaHandlerClass);
        this.tenantResolver = multiTenantResolver;
        if (multiTenantResolver instanceof DatastoreAware) {
            ((DatastoreAware)multiTenantResolver).setDatastore((Datastore)this);
        }
    }

    protected AbstractHibernateDatastore(MappingContext mappingContext, SessionFactory sessionFactory, PropertyResolver config, ApplicationContext applicationContext, String dataSourceName) {
        super(mappingContext, config, (ConfigurableApplicationContext)applicationContext);
        this.connectionSources = new SingletonConnectionSources((ConnectionSource)new HibernateConnectionSource(dataSourceName, sessionFactory, null, null), config);
        this.sessionFactory = sessionFactory;
        this.dataSourceName = dataSourceName;
        this.initializeConverters(mappingContext);
        if (applicationContext != null) {
            this.setApplicationContext(applicationContext);
        }
        this.osivReadOnly = (Boolean)config.getProperty(CONFIG_PROPERTY_OSIV_READONLY, Boolean.class, (Object)false);
        this.passReadOnlyToHibernate = (Boolean)config.getProperty(CONFIG_PROPERTY_PASS_READONLY_TO_HIBERNATE, Boolean.class, (Object)false);
        this.isCacheQueries = (Boolean)config.getProperty(CONFIG_PROPERTY_CACHE_QUERIES, Boolean.class, (Object)false);
        if (((Boolean)config.getProperty("grails.gorm.autoFlush", Boolean.class, (Object)false)).booleanValue()) {
            this.defaultFlushModeName = FlushMode.AUTO.name();
            this.defaultFlushMode = FlushMode.AUTO.level;
        } else {
            FlushMode flushMode = (FlushMode)((Object)config.getProperty("grails.gorm.flushMode", FlushMode.class, (Object)FlushMode.COMMIT));
            this.defaultFlushModeName = flushMode.name();
            this.defaultFlushMode = flushMode.level;
        }
        this.failOnError = (Boolean)config.getProperty("grails.gorm.failOnError", Boolean.class, (Object)false);
        this.markDirty = (Boolean)config.getProperty("grails.gorm.markDirty", Boolean.class, (Object)false);
        this.tenantResolver = new FixedTenantResolver();
        this.multiTenantMode = MultiTenancySettings.MultiTenancyMode.NONE;
        this.schemaHandler = new DefaultSchemaHandler();
    }

    public AbstractHibernateDatastore(MappingContext mappingContext, SessionFactory sessionFactory, PropertyResolver config) {
        this(mappingContext, sessionFactory, config, null, "DEFAULT");
    }

    public void setMessageSource(MessageSource messageSource) {
        ValidatorRegistry validatorRegistry = this.createValidatorRegistry(messageSource);
        this.mappingContext.setValidatorRegistry(validatorRegistry);
    }

    protected ValidatorRegistry createValidatorRegistry(MessageSource messageSource) {
        return ValidatorRegistries.createValidatorRegistry((MappingContext)this.mappingContext, (ConnectionSourceSettings)this.getConnectionSources().getDefaultConnectionSource().getSettings(), (MessageSource)messageSource);
    }

    public MultiTenancySettings.MultiTenancyMode getMultiTenancyMode() {
        return this.multiTenantMode == MultiTenancySettings.MultiTenancyMode.SCHEMA ? MultiTenancySettings.MultiTenancyMode.DATABASE : this.multiTenantMode;
    }

    public Datastore getDatastoreForTenantId(Serializable tenantId) {
        if (this.multiTenantMode == MultiTenancySettings.MultiTenancyMode.DATABASE) {
            return this.getDatastoreForConnection(tenantId.toString());
        }
        return this;
    }

    public TenantResolver getTenantResolver() {
        return this.tenantResolver;
    }

    public ConnectionSources<SessionFactory, HibernateConnectionSourceSettings> getConnectionSources() {
        return this.connectionSources;
    }

    public abstract AbstractHibernateDatastore getDatastoreForConnection(String var1);

    public Iterable<Serializable> resolveTenantIds() {
        if (this.tenantResolver instanceof AllTenantsResolver) {
            return ((AllTenantsResolver)this.tenantResolver).resolveTenantIds();
        }
        if (this.multiTenantMode == MultiTenancySettings.MultiTenancyMode.DATABASE) {
            ArrayList<Serializable> tenantIds = new ArrayList<Serializable>();
            for (ConnectionSource connectionSource : this.connectionSources.getAllConnectionSources()) {
                if ("DEFAULT".equals(connectionSource.getName())) continue;
                tenantIds.add((Serializable)((Object)connectionSource.getName()));
            }
            return tenantIds;
        }
        return Collections.emptyList();
    }

    public Serializable resolveTenantIdentifier() throws TenantNotFoundException {
        return Tenants.currentId((MultiTenantCapableDatastore)this);
    }

    public boolean isAutoFlush() {
        return this.defaultFlushMode == FlushMode.AUTO.level;
    }

    public int getDefaultFlushMode() {
        return this.defaultFlushMode;
    }

    public String getDefaultFlushModeName() {
        return this.defaultFlushModeName;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public boolean isOsivReadOnly() {
        return this.osivReadOnly;
    }

    public boolean isPassReadOnlyToHibernate() {
        return this.passReadOnlyToHibernate;
    }

    public boolean isCacheQueries() {
        return this.isCacheQueries;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public DataSource getDataSource() {
        return ((HibernateConnectionSource)this.connectionSources.getDefaultConnectionSource()).getDataSource();
    }

    public AbstractHibernateEventListener getEventTriggeringInterceptor() {
        return this.eventTriggeringInterceptor;
    }

    public AutoTimestampEventListener getAutoTimestampEventListener() {
        return this.autoTimestampEventListener;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public abstract void withFlushMode(FlushMode var1, Callable<Boolean> var2);

    public void destroy() {
        if (!this.destroyed) {
            super.destroy();
            AbstractHibernateGormInstanceApi.resetInsertActive();
            try {
                this.connectionSources.close();
            }
            catch (IOException e) {
                LOG.error("There was an error shutting down GORM for an entity: " + e.getMessage(), (Throwable)e);
            }
            this.destroyed = true;
        }
    }

    @Override
    @PreDestroy
    public void close() {
        try {
            this.destroy();
        }
        catch (Exception e) {
            LOG.error("Error closing hibernate datastore: " + e.getMessage(), (Throwable)e);
        }
    }

    public abstract IHibernateTemplate getHibernateTemplate(int var1);

    public IHibernateTemplate getHibernateTemplate() {
        return this.getHibernateTemplate(this.defaultFlushMode);
    }

    public abstract Session openSession();

    public <T> T withSession(Closure<T> callable) {
        Closure<T> multiTenantCallable = this.prepareMultiTenantClosure(callable);
        return this.getHibernateTemplate().execute(multiTenantCallable);
    }

    public <T> T withNewSession(Closure<T> callable) {
        Closure<T> multiTenantCallable = this.prepareMultiTenantClosure(callable);
        return this.getHibernateTemplate().executeWithNewSession(multiTenantCallable);
    }

    public <T1> T1 withNewSession(Serializable tenantId, Closure<T1> callable) {
        if (this.getMultiTenancyMode() == MultiTenancySettings.MultiTenancyMode.DATABASE) {
            AbstractHibernateDatastore datastore = this.getDatastoreForConnection(tenantId.toString());
            SessionFactory sessionFactory = datastore.getSessionFactory();
            return datastore.getHibernateTemplate().executeWithExistingOrCreateNewSession(sessionFactory, callable);
        }
        return this.withNewSession(callable);
    }

    public void enableMultiTenancyFilter() {
        Serializable currentId = Tenants.currentId((MultiTenantCapableDatastore)this);
        if ("DEFAULT".equals(currentId)) {
            this.disableMultiTenancyFilter();
        } else {
            this.getHibernateTemplate().getSessionFactory().getCurrentSession().enableFilter("tenantId").setParameter("tenantId", (Object)currentId);
        }
    }

    public void disableMultiTenancyFilter() {
        this.getHibernateTemplate().getSessionFactory().getCurrentSession().disableFilter("tenantId");
    }

    protected <T> Closure<T> prepareMultiTenantClosure(final Closure<T> callable) {
        boolean isMultiTenant = this.getMultiTenancyMode() == MultiTenancySettings.MultiTenancyMode.DISCRIMINATOR;
        Closure multiTenantCallable = isMultiTenant ? new Closure<T>(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T call(Object ... args) {
                AbstractHibernateDatastore.this.enableMultiTenancyFilter();
                try {
                    Object object = callable.call(args);
                    return object;
                }
                finally {
                    AbstractHibernateDatastore.this.disableMultiTenancyFilter();
                }
            }
        } : callable;
        return multiTenantCallable;
    }

    public static enum FlushMode {
        MANUAL(0),
        COMMIT(5),
        AUTO(10),
        ALWAYS(20);

        private final int level;

        private FlushMode(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

