/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.images;

import fr.opensagres.xdocreport.document.images.IImageInfo;
import fr.opensagres.xdocreport.document.images.IImageProvider;
import fr.opensagres.xdocreport.template.formatter.NullImageBehaviour;
import java.io.IOException;

public abstract class AbstractImageProvider
implements IImageProvider {
    private IImageInfo imageInfo;
    private Float width;
    private Float height;
    private Float widthFromImageInfo;
    private Float heightFromImageInfo;
    private boolean useImageSize;
    private boolean resize;
    private NullImageBehaviour behaviour;
    private Boolean valid;

    public AbstractImageProvider(boolean useImageSize) {
        this.useImageSize = useImageSize;
        this.behaviour = null;
    }

    @Override
    public boolean isUseImageSize() {
        return this.useImageSize;
    }

    @Override
    public void setUseImageSize(boolean useImageSize) {
        this.useImageSize = useImageSize;
        this.resetImageInfo();
    }

    @Override
    public Float getWidth(Float defaultWidth) throws IOException {
        if (this.width != null) {
            return this.width;
        }
        if (!this.isUseImageSize()) {
            return null;
        }
        if (this.widthFromImageInfo != null) {
            return this.widthFromImageInfo;
        }
        if (this.height != null && this.isResize()) {
            float ratio = new Float(this.getImageInfo().getWidth()).floatValue() / new Float(this.getImageInfo().getHeight()).floatValue();
            this.widthFromImageInfo = new Float(Math.round(this.height.floatValue() * ratio));
            return this.widthFromImageInfo;
        }
        this.widthFromImageInfo = new Float(this.getImageInfo().getWidth());
        return this.widthFromImageInfo;
    }

    @Override
    public Float getHeight(Float defaultHeight) throws IOException {
        if (this.height != null) {
            return this.height;
        }
        if (!this.isUseImageSize()) {
            return null;
        }
        if (this.heightFromImageInfo != null) {
            return this.heightFromImageInfo;
        }
        if (this.width != null && this.isResize()) {
            float ratio = new Float(this.getImageInfo().getHeight()).floatValue() / new Float(this.getImageInfo().getWidth()).floatValue();
            this.heightFromImageInfo = new Float(Math.round(this.width.floatValue() * ratio));
            return this.heightFromImageInfo;
        }
        this.heightFromImageInfo = new Float(this.getImageInfo().getHeight());
        return this.heightFromImageInfo;
    }

    @Override
    public void setWidth(Float width) {
        this.width = width;
        this.resetImageInfo();
    }

    @Override
    public void setHeight(Float height) {
        this.height = height;
        this.resetImageInfo();
    }

    @Override
    public void setSize(Float width, Float height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public IImageInfo getImageInfo() throws IOException {
        if (this.imageInfo == null) {
            this.imageInfo = this.loadImageInfo();
        }
        return this.imageInfo;
    }

    public void resetImageInfo() {
        this.widthFromImageInfo = null;
        this.heightFromImageInfo = null;
        this.imageInfo = null;
    }

    @Override
    public void setResize(boolean resize) {
        this.resize = resize;
        this.resetImageInfo();
    }

    @Override
    public boolean isResize() {
        return this.resize;
    }

    protected abstract IImageInfo loadImageInfo() throws IOException;

    @Override
    public NullImageBehaviour getBehaviour() {
        return this.behaviour;
    }

    @Override
    public void setBehaviour(NullImageBehaviour behaviour) {
        this.behaviour = behaviour;
    }

    @Override
    public boolean isValid() {
        if (this.valid == null) {
            this.valid = this.doIsValid();
        }
        return this.valid;
    }

    protected abstract boolean doIsValid();
}

