/*
 * Decompiled with CFR 0.152.
 */
package fr.w3blog.zpl.constant;

public enum ZebraPaperType {
    CONTINUOUS("N"),
    NON_CONTINUOUS_WEB_SENSING("W"),
    MARK_SENSING("M");

    String desiredMode;
    int blackMarkOffsetInDots = 0;

    private ZebraPaperType(String desiredMode) {
        this.desiredMode = desiredMode;
        this.blackMarkOffsetInDots = 0;
    }

    private ZebraPaperType(String desiredMode, int blackMarkOffsetInDots) {
        this.desiredMode = desiredMode;
        this.blackMarkOffsetInDots = blackMarkOffsetInDots;
    }

    public String getDesiredMode() {
        return this.desiredMode;
    }

    public String getZplCode() {
        if (this.desiredMode.equalsIgnoreCase("M")) {
            return "^MN" + this.desiredMode + "," + this.blackMarkOffsetInDots + "\n";
        }
        return "^MN" + this.desiredMode + "\n";
    }

    public static ZebraPaperType getPaperType(String letter) {
        ZebraPaperType myPaperType = CONTINUOUS;
        switch (letter) {
            case "CONTINUOUS": {
                myPaperType = CONTINUOUS;
                break;
            }
            case "NON_CONTINUOUS_WEB_SENSING": {
                myPaperType = NON_CONTINUOUS_WEB_SENSING;
                break;
            }
            case "MARK_SENSING": {
                myPaperType = MARK_SENSING;
                break;
            }
            default: {
                myPaperType = CONTINUOUS;
            }
        }
        return myPaperType;
    }
}

