/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.taglib.encoder;

import grails.core.GrailsApplication;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import org.grails.encoder.EncodingStateRegistry;
import org.grails.taglib.AbstractTemplateVariableBinding;
import org.grails.taglib.TemplateVariableBinding;
import org.grails.taglib.encoder.OutputContext;
import org.grails.taglib.encoder.OutputContextLookup;
import org.grails.taglib.encoder.OutputEncodingStack;
import org.grails.web.servlet.WrappedResponseHolder;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.grails.web.taglib.WebRequestTemplateVariableBinding;
import org.springframework.core.Ordered;

public class WebOutputContextLookup
implements OutputContextLookup,
Ordered {
    private static final WebOutputContext webOutputContext = new WebOutputContext();
    static final String ATTRIBUTE_NAME_OUTPUT_STACK = "org.grails.web.encoder.OUTPUT_ENCODING_STACK";

    public OutputContext lookupOutputContext() {
        return webOutputContext;
    }

    public int getOrder() {
        return 0;
    }

    static class WebOutputContext
    implements OutputContext {
        WebOutputContext() {
        }

        public EncodingStateRegistry getEncodingStateRegistry() {
            GrailsWebRequest grailsWebRequest = this.lookupWebRequest();
            if (grailsWebRequest != null) {
                return grailsWebRequest.getEncodingStateRegistry();
            }
            return null;
        }

        public void setCurrentOutputEncodingStack(OutputEncodingStack outputEncodingStack) {
            GrailsWebRequest grailsWebRequest = this.lookupWebRequest();
            if (grailsWebRequest != null) {
                grailsWebRequest.setAttribute(WebOutputContextLookup.ATTRIBUTE_NAME_OUTPUT_STACK, (Object)outputEncodingStack, 0);
            }
        }

        public OutputEncodingStack getCurrentOutputEncodingStack() {
            GrailsWebRequest grailsWebRequest = this.lookupWebRequest();
            if (grailsWebRequest != null) {
                return (OutputEncodingStack)grailsWebRequest.getAttribute(WebOutputContextLookup.ATTRIBUTE_NAME_OUTPUT_STACK, 0);
            }
            return null;
        }

        public Writer getCurrentWriter() {
            return this.lookupWebRequest().getOut();
        }

        public void setCurrentWriter(Writer currentWriter) {
            GrailsWebRequest grailsWebRequest = this.lookupWebRequest();
            if (grailsWebRequest != null) {
                grailsWebRequest.setOut(currentWriter);
            }
        }

        public AbstractTemplateVariableBinding createAndRegisterRootBinding() {
            GrailsWebRequest webRequest = this.lookupWebRequest();
            WebRequestTemplateVariableBinding binding = webRequest != null ? new WebRequestTemplateVariableBinding(webRequest) : new TemplateVariableBinding();
            this.setBinding(binding);
            return binding;
        }

        public AbstractTemplateVariableBinding getBinding() {
            GrailsWebRequest grailsWebRequest = this.lookupWebRequest();
            if (grailsWebRequest == null) {
                return null;
            }
            return (AbstractTemplateVariableBinding)grailsWebRequest.getAttribute("org.grails.PAGE_SCOPE", 0);
        }

        public void setBinding(AbstractTemplateVariableBinding binding) {
            GrailsWebRequest grailsWebRequest = this.lookupWebRequest();
            if (grailsWebRequest != null) {
                grailsWebRequest.setAttribute("org.grails.PAGE_SCOPE", (Object)binding, 0);
            }
        }

        public GrailsApplication getGrailsApplication() {
            GrailsWebRequest grailsWebRequest = this.lookupWebRequest();
            if (grailsWebRequest != null) {
                return grailsWebRequest.getAttributes().getGrailsApplication();
            }
            return null;
        }

        public void setContentType(String contentType) {
            HttpServletResponse httpServletResponse = this.lookupResponse();
            if (httpServletResponse != null) {
                httpServletResponse.setContentType(contentType);
            }
        }

        public boolean isContentTypeAlreadySet() {
            GrailsWebRequest webRequest = this.lookupWebRequest();
            HttpServletResponse response = webRequest.getResponse();
            return response.isCommitted() || response.getContentType() != null && webRequest.getRequest().getAttribute("javax.servlet.error.exception") == null;
        }

        protected GrailsWebRequest lookupWebRequest() {
            return GrailsWebRequest.lookup();
        }

        protected HttpServletResponse lookupResponse() {
            HttpServletResponse wrapped = WrappedResponseHolder.getWrappedResponse();
            if (wrapped != null) {
                return wrapped;
            }
            GrailsWebRequest grailsWebRequest = this.lookupWebRequest();
            if (grailsWebRequest != null) {
                return grailsWebRequest.getCurrentResponse();
            }
            return null;
        }
    }
}

