/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.compare.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.compare.DatabaseObjectComparator;
import liquibase.diff.compare.DatabaseObjectComparatorChain;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.diff.compare.core.DefaultDatabaseObjectComparator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Relation;
import liquibase.structure.core.UniqueConstraint;
import liquibase.util.StringUtils;

public class UniqueConstraintComparator
implements DatabaseObjectComparator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (UniqueConstraint.class.isAssignableFrom(objectType)) {
            return 5;
        }
        return -1;
    }

    @Override
    public String[] hash(DatabaseObject databaseObject, Database accordingTo, DatabaseObjectComparatorChain chain) {
        Relation table;
        ArrayList<String> hashes = new ArrayList<String>();
        if (databaseObject.getName() != null) {
            hashes.add(databaseObject.getName().toLowerCase());
        }
        if ((table = ((UniqueConstraint)databaseObject).getRelation()) != null) {
            hashes.addAll(Arrays.asList(DatabaseObjectComparatorFactory.getInstance().hash(table, chain.getSchemaComparisons(), accordingTo)));
        }
        return hashes.toArray(new String[hashes.size()]);
    }

    @Override
    public boolean isSameObject(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, DatabaseObjectComparatorChain chain) {
        if (!(databaseObject1 instanceof UniqueConstraint) || !(databaseObject2 instanceof UniqueConstraint)) {
            return false;
        }
        UniqueConstraint thisConstraint = (UniqueConstraint)databaseObject1;
        UniqueConstraint otherConstraint = (UniqueConstraint)databaseObject2;
        int thisConstraintSize = thisConstraint.getColumns().size();
        int otherConstraintSize = otherConstraint.getColumns().size();
        if (thisConstraint.getRelation() != null && otherConstraint.getRelation() != null) {
            if (!DatabaseObjectComparatorFactory.getInstance().isSameObject(thisConstraint.getRelation(), otherConstraint.getRelation(), chain.getSchemaComparisons(), accordingTo)) {
                return false;
            }
            if (databaseObject1.getSchema() != null && databaseObject2.getSchema() != null && !DatabaseObjectComparatorFactory.getInstance().isSameObject(databaseObject1.getSchema(), databaseObject2.getSchema(), chain.getSchemaComparisons(), accordingTo)) {
                return false;
            }
            if (databaseObject1.getName() != null && databaseObject2.getName() != null && DefaultDatabaseObjectComparator.nameMatches(databaseObject1, databaseObject2, accordingTo)) {
                return true;
            }
            if (thisConstraintSize == 0 || otherConstraintSize == 0) {
                return DefaultDatabaseObjectComparator.nameMatches(databaseObject1, databaseObject2, accordingTo);
            }
            if (thisConstraintSize > 0 && otherConstraintSize > 0 && thisConstraintSize != otherConstraintSize) {
                return false;
            }
            for (int i2 = 0; i2 < otherConstraintSize; ++i2) {
                if (DatabaseObjectComparatorFactory.getInstance().isSameObject(thisConstraint.getColumns().get(i2).setRelation(thisConstraint.getRelation()), otherConstraint.getColumns().get(i2).setRelation(otherConstraint.getRelation()), chain.getSchemaComparisons(), accordingTo)) continue;
                return false;
            }
            return true;
        }
        if (thisConstraintSize > 0 && otherConstraintSize > 0 && thisConstraintSize != otherConstraintSize) {
            return false;
        }
        if (!DefaultDatabaseObjectComparator.nameMatches(databaseObject1, databaseObject2, accordingTo)) {
            return false;
        }
        if (databaseObject1.getSchema() != null && databaseObject2.getSchema() != null) {
            return DatabaseObjectComparatorFactory.getInstance().isSameObject(databaseObject1.getSchema(), databaseObject2.getSchema(), chain.getSchemaComparisons(), accordingTo);
        }
        return true;
    }

    @Override
    public ObjectDifferences findDifferences(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, CompareControl compareControl, DatabaseObjectComparatorChain chain, Set<String> exclude) {
        exclude.add("name");
        exclude.add("columns");
        exclude.add("backingIndex");
        ObjectDifferences differences = chain.findDifferences(databaseObject1, databaseObject2, accordingTo, compareControl, exclude);
        differences.compare("columns", databaseObject1, databaseObject2, new ObjectDifferences.CompareFunction(){

            @Override
            public boolean areEqual(Object referenceValue, Object compareToValue) {
                List referenceList = (List)referenceValue;
                List compareList = (List)compareToValue;
                if (referenceList.size() != compareList.size()) {
                    return false;
                }
                for (int i2 = 0; i2 < referenceList.size(); ++i2) {
                    if (StringUtils.trimToEmpty(((Column)referenceList.get(i2)).getName()).equalsIgnoreCase(StringUtils.trimToEmpty(((Column)compareList.get(i2)).getName()))) continue;
                    return false;
                }
                return true;
            }
        });
        differences.compare("backingIndex", databaseObject1, databaseObject2, new ObjectDifferences.StandardCompareFunction(chain.getSchemaComparisons(), accordingTo));
        return differences;
    }
}

