/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.finders;

import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.grails.datastore.gorm.finders.AbstractFindByFinder;
import org.grails.datastore.gorm.finders.DynamicFinderInvocation;
import org.grails.datastore.gorm.finders.MethodExpression;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.model.MappingContext;
import org.springframework.core.convert.ConversionException;

public class FindOrCreateByFinder
extends AbstractFindByFinder {
    public static final String METHOD_PATTERN = "(findOrCreateBy)([A-Z]\\w*)";

    public FindOrCreateByFinder(String methodPattern, Datastore datastore) {
        super(Pattern.compile(methodPattern), datastore);
    }

    public FindOrCreateByFinder(Datastore datastore) {
        this(METHOD_PATTERN, datastore);
    }

    public FindOrCreateByFinder(MappingContext mappingContext) {
        super(Pattern.compile(METHOD_PATTERN), mappingContext);
    }

    public FindOrCreateByFinder(String methodPattern, MappingContext mappingContext) {
        super(Pattern.compile(methodPattern), mappingContext);
    }

    @Override
    protected Object doInvokeInternal(DynamicFinderInvocation invocation) {
        Object result;
        if ("Or".equals(invocation.getOperator())) {
            throw new MissingMethodException(invocation.getMethodName(), invocation.getJavaClass(), invocation.getArguments());
        }
        try {
            result = super.doInvokeInternal(invocation);
        }
        catch (ConversionException e) {
            throw new MissingMethodException(invocation.getMethodName(), invocation.getJavaClass(), invocation.getArguments());
        }
        if (result == null) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            List<MethodExpression> expressions = invocation.getExpressions();
            for (MethodExpression me : expressions) {
                if (!(me instanceof MethodExpression.Equal)) {
                    throw new MissingMethodException(invocation.getMethodName(), invocation.getJavaClass(), invocation.getArguments());
                }
                String propertyName = me.propertyName;
                Object[] arguments = me.getArguments();
                m.put(propertyName, arguments[0]);
            }
            MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(invocation.getJavaClass());
            result = metaClass.invokeConstructor(new Object[]{m});
            if (this.shouldSaveOnCreate()) {
                metaClass.invokeMethod(result, "save", null);
            }
        }
        return result;
    }

    protected boolean shouldSaveOnCreate() {
        return false;
    }
}

