<#--

    Copyright (C) 2011-2015 The XDocReport Team <xdocreport@googlegroups.com>

    All rights reserved.

    Permission is hereby granted, free  of charge, to any person obtaining
    a  copy  of this  software  and  associated  documentation files  (the
    "Software"), to  deal in  the Software without  restriction, including
    without limitation  the rights to  use, copy, modify,  merge, publish,
    distribute,  sublicense, and/or sell  copies of  the Software,  and to
    permit persons to whom the Software  is furnished to do so, subject to
    the following conditions:

    The  above  copyright  notice  and  this permission  notice  shall  be
    included in all copies or substantial portions of the Software.

    THE  SOFTWARE IS  PROVIDED  "AS  IS", WITHOUT  WARRANTY  OF ANY  KIND,
    EXPRESS OR  IMPLIED, INCLUDING  BUT NOT LIMITED  TO THE  WARRANTIES OF
    MERCHANTABILITY,    FITNESS    FOR    A   PARTICULAR    PURPOSE    AND
    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
    OF CONTRACT, TORT OR OTHERWISE,  ARISING FROM, OUT OF OR IN CONNECTION
    WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

-->
[#if packageName ?? ]package ${packageName};[/#if]

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Map;

import fr.opensagres.xdocreport.core.utils.Base64Utility;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.json.JSONObject;
import fr.opensagres.xdocreport.document.json.JSONTokener;
import fr.opensagres.xdocreport.document.registry.XDocReportRegistry;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadataXMLSerializer;

public class ${className}
{

    public static void main( String[] args )
    {
        try
        {
            // Load report
            [#if document ?? ]
            String document = "${document}";
            InputStream in = new ByteArrayInputStream( Base64Utility.decode( document ) );
            [#else]
            InputStream in = ${className}.class.getResourceAsStream("${documentFile}");
            [/#if]
            IXDocReport report = XDocReportRegistry.getRegistry().loadReport( in, null, "${templateEngineKind}" );
            [#if xmlFields ?? ]
            
            // Set FieldsMetadata
            StringReader fieldsReader = new StringReader(${xmlFields});
            FieldsMetadata metadata = FieldsMetadataXMLSerializer.getInstance().load( fieldsReader );
            report.setFieldsMetadata( metadata );
            [#else]
            [#if xmlFieldsFile ?? ]
            
            // Set FieldsMetadata
            InputStream fieldsStream = ${className}.class.getResourceAsStream("${xmlFieldsFile}");
            FieldsMetadata metadata = FieldsMetadataXMLSerializer.getInstance().load( fieldsStream );
            report.setFieldsMetadata( metadata );
            [/#if]
            [/#if]
            			 
            // Create context
            [#if json ?? ]
            String json = "${json}";
            Map context = new JSONObject( json );
            [#else]
            InputStream jsonStream = ${className}.class.getResourceAsStream("${jsonFile}");
            Map context = new JSONObject( new JSONTokener(jsonStream) );
            [/#if]

            // Generate report by merging context and template report.
            OutputStream out = new FileOutputStream( new File( "${outFileName}" ) );
            report.process( context, out );

        }
        catch ( Exception e )
        {
            e.printStackTrace();
        }
    }
}
