/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.wmf2svg.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public class DataInput {
    private InputStream in;
    private ByteOrder endian;
    private byte[] buf = new byte[4];
    private int count = 0;

    public DataInput(InputStream in) {
        this.endian = ByteOrder.nativeOrder();
        this.in = in;
    }

    public DataInput(InputStream in, ByteOrder endian) {
        if (endian != ByteOrder.BIG_ENDIAN && endian != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException();
        }
        this.in = in;
        this.endian = endian;
    }

    public int readByte() throws IOException, EOFException {
        if (this.in.read(this.buf, 0, 1) == 1) {
            ++this.count;
            return 0xFF & this.buf[0];
        }
        throw new EOFException();
    }

    public int readInt16() throws IOException, EOFException {
        if (this.in.read(this.buf, 0, 2) == 2) {
            int value = 0;
            if (this.endian == ByteOrder.BIG_ENDIAN) {
                value = (short)(value | 0xFF & this.buf[1]);
                value = (short)(value | (0xFF & this.buf[0]) << 8);
            } else {
                value = (short)(value | 0xFF & this.buf[0]);
                value = (short)(value | (0xFF & this.buf[1]) << 8);
            }
            this.count += 2;
            return value;
        }
        throw new EOFException();
    }

    public int readInt32() throws IOException, EOFException {
        if (this.in.read(this.buf, 0, 4) == 4) {
            int value = 0;
            if (this.endian == ByteOrder.BIG_ENDIAN) {
                value |= 0xFF & this.buf[3];
                value |= (0xFF & this.buf[2]) << 8;
                value |= (0xFF & this.buf[1]) << 16;
                value |= (0xFF & this.buf[0]) << 24;
            } else {
                value |= 0xFF & this.buf[0];
                value |= (0xFF & this.buf[1]) << 8;
                value |= (0xFF & this.buf[2]) << 16;
                value |= (0xFF & this.buf[3]) << 24;
            }
            this.count += 4;
            return value;
        }
        throw new EOFException();
    }

    public int readUint16() throws IOException, EOFException {
        if (this.in.read(this.buf, 0, 2) == 2) {
            int value = 0;
            if (this.endian == ByteOrder.BIG_ENDIAN) {
                value |= 0xFF & this.buf[1];
                value |= (0xFF & this.buf[0]) << 8;
            } else {
                value |= 0xFF & this.buf[0];
                value |= (0xFF & this.buf[1]) << 8;
            }
            this.count += 2;
            return value;
        }
        throw new EOFException();
    }

    public long readUint32() throws IOException, EOFException {
        if (this.in.read(this.buf, 0, 4) == 4) {
            long value = 0L;
            if (this.endian == ByteOrder.BIG_ENDIAN) {
                value |= (long)(0xFF & this.buf[3]);
                value |= (long)((0xFF & this.buf[2]) << 8);
                value |= (long)((0xFF & this.buf[1]) << 16);
                value |= (long)((0xFF & this.buf[0]) << 24);
            } else {
                value |= (long)(0xFF & this.buf[0]);
                value |= (long)((0xFF & this.buf[1]) << 8);
                value |= (long)((0xFF & this.buf[2]) << 16);
                value |= (long)((0xFF & this.buf[3]) << 24);
            }
            this.count += 4;
            return value;
        }
        throw new EOFException();
    }

    public byte[] readBytes(int n) throws IOException, EOFException {
        byte[] array = new byte[n];
        if (this.in.read(array) == n) {
            this.count += n;
            return array;
        }
        throw new EOFException();
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

