/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.joda.columnmapper;

import java.sql.Timestamp;
import org.jadira.usertype.dateandtime.joda.util.Formatter;
import org.jadira.usertype.dateandtime.joda.util.ZoneHelper;
import org.jadira.usertype.dateandtime.shared.spi.AbstractVersionableTimestampColumnMapper;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class TimestampColumnInstantMapper
extends AbstractVersionableTimestampColumnMapper<Instant> {
    private static final long serialVersionUID = -7670411089210984705L;
    private DateTimeZone databaseZone = DateTimeZone.UTC;

    public Instant fromNonNullString(String s) {
        return new Instant((Object)s);
    }

    public Instant fromNonNullValue(Timestamp value) {
        DateTimeZone currentDatabaseZone = this.databaseZone == null ? ZoneHelper.getDefault() : this.databaseZone;
        return Formatter.LOCAL_DATETIME_FORMATTER.withZone(currentDatabaseZone).parseDateTime(value.toString()).toInstant();
    }

    public String toNonNullString(Instant value) {
        return value.toString();
    }

    public Timestamp toNonNullValue(Instant value) {
        DateTimeZone currentDatabaseZone = this.databaseZone == null ? ZoneHelper.getDefault() : this.databaseZone;
        String formattedTimestamp = Formatter.LOCAL_DATETIME_FORMATTER.withZone(currentDatabaseZone).print((ReadableInstant)value);
        if (formattedTimestamp.endsWith(".")) {
            formattedTimestamp = formattedTimestamp.substring(0, formattedTimestamp.length() - 1);
        }
        Timestamp timestamp = Timestamp.valueOf(formattedTimestamp);
        return timestamp;
    }

    public void setDatabaseZone(DateTimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }
}

