/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.event.listener;

import grails.gorm.MultiTenant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.grails.datastore.gorm.timestamp.DefaultTimestampProvider;
import org.grails.datastore.gorm.timestamp.TimestampProvider;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEvent;
import org.grails.datastore.mapping.engine.event.ValidationEvent;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.orm.hibernate.AbstractHibernateDatastore;
import org.grails.orm.hibernate.event.listener.AbstractHibernateEventListener;
import org.grails.orm.hibernate.support.ClosureEventListener;
import org.grails.orm.hibernate.support.SoftKey;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PreDeleteEvent;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.SaveOrUpdateEvent;
import org.springframework.context.ApplicationEvent;

public class HibernateEventListener
extends AbstractHibernateEventListener {
    protected transient ConcurrentMap<SoftKey<Class<?>>, ClosureEventListener> eventListeners = new ConcurrentHashMap();

    public HibernateEventListener(AbstractHibernateDatastore datastore) {
        super(datastore);
    }

    protected void onPersistenceEvent(AbstractPersistenceEvent event) {
        switch (event.getEventType()) {
            case PreInsert: {
                if (!this.onPreInsert((PreInsertEvent)event.getNativeEvent())) break;
                event.cancel();
                break;
            }
            case PostInsert: {
                this.onPostInsert((PostInsertEvent)event.getNativeEvent());
                break;
            }
            case PreUpdate: {
                if (!this.onPreUpdate((PreUpdateEvent)event.getNativeEvent())) break;
                event.cancel();
                break;
            }
            case PostUpdate: {
                this.onPostUpdate((PostUpdateEvent)event.getNativeEvent());
                break;
            }
            case PreDelete: {
                if (!this.onPreDelete((PreDeleteEvent)event.getNativeEvent())) break;
                event.cancel();
                break;
            }
            case PostDelete: {
                this.onPostDelete((PostDeleteEvent)event.getNativeEvent());
                break;
            }
            case PreLoad: {
                this.onPreLoad((PreLoadEvent)event.getNativeEvent());
                break;
            }
            case PostLoad: {
                this.onPostLoad((PostLoadEvent)event.getNativeEvent());
                break;
            }
            case SaveOrUpdate: {
                this.onSaveOrUpdate((SaveOrUpdateEvent)event.getNativeEvent());
                break;
            }
            case Validation: {
                this.onValidate((ValidationEvent)event);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected EventType: " + event.getEventType());
            }
        }
    }

    public void onSaveOrUpdate(SaveOrUpdateEvent event) throws HibernateException {
        EventSource session;
        ClosureEventListener eventListener;
        Object entity = event.getObject();
        if (entity != null && (eventListener = this.findEventListener(entity, (SessionFactoryImplementor)(session = event.getSession()).getSessionFactory())) != null) {
            eventListener.onSaveOrUpdate(event);
        }
    }

    public void onPreLoad(PreLoadEvent event) {
        Object entity = event.getEntity();
        ClosureEventListener eventListener = this.findEventListener(entity, event.getPersister().getFactory());
        if (eventListener != null) {
            eventListener.onPreLoad(event);
        }
    }

    public void onPostLoad(PostLoadEvent event) {
        ClosureEventListener eventListener = this.findEventListener(event.getEntity(), event.getPersister().getFactory());
        if (eventListener != null) {
            eventListener.onPostLoad(event);
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        ClosureEventListener eventListener = this.findEventListener(event.getEntity(), event.getPersister().getFactory());
        if (eventListener != null) {
            eventListener.onPostInsert(event);
        }
    }

    public boolean onPreInsert(PreInsertEvent event) {
        boolean evict = false;
        ClosureEventListener eventListener = this.findEventListener(event.getEntity(), event.getPersister().getFactory());
        if (eventListener != null) {
            evict = eventListener.onPreInsert(event);
        }
        return evict;
    }

    public boolean onPreUpdate(PreUpdateEvent event) {
        boolean evict = false;
        ClosureEventListener eventListener = this.findEventListener(event.getEntity(), event.getPersister().getFactory());
        if (eventListener != null) {
            evict = eventListener.onPreUpdate(event);
        }
        return evict;
    }

    public void onPostUpdate(PostUpdateEvent event) {
        ClosureEventListener eventListener = this.findEventListener(event.getEntity(), event.getPersister().getFactory());
        if (eventListener != null) {
            eventListener.onPostUpdate(event);
        }
    }

    public boolean onPreDelete(PreDeleteEvent event) {
        boolean evict = false;
        ClosureEventListener eventListener = this.findEventListener(event.getEntity(), event.getPersister().getFactory());
        if (eventListener != null) {
            evict = eventListener.onPreDelete(event);
        }
        return evict;
    }

    public void onPostDelete(PostDeleteEvent event) {
        ClosureEventListener eventListener = this.findEventListener(event.getEntity(), event.getPersister().getFactory());
        if (eventListener != null) {
            eventListener.onPostDelete(event);
        }
    }

    public void onValidate(ValidationEvent event) {
        ClosureEventListener eventListener = this.findEventListener(event.getEntityObject(), null);
        if (eventListener != null) {
            eventListener.onValidate(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClosureEventListener findEventListener(Object entity, SessionFactoryImplementor factory) {
        if (entity == null) {
            return null;
        }
        Class clazz = Hibernate.getClass((Object)entity);
        SoftKey<Class> key = new SoftKey<Class>(clazz);
        ClosureEventListener eventListener = (ClosureEventListener)this.eventListeners.get(key);
        if (eventListener != null) {
            return eventListener;
        }
        Boolean shouldTrigger = (Boolean)this.cachedShouldTrigger.get(key);
        if (shouldTrigger == null || shouldTrigger.booleanValue()) {
            ConcurrentMap concurrentMap = this.cachedShouldTrigger;
            synchronized (concurrentMap) {
                eventListener = (ClosureEventListener)this.eventListeners.get(key);
                if (eventListener == null) {
                    ClosureEventListener previous;
                    AbstractHibernateDatastore datastore = this.getDatastore();
                    boolean isValidSessionFactory = MultiTenant.class.isAssignableFrom(clazz) || factory == null || datastore.getSessionFactory().equals(factory);
                    PersistentEntity persistentEntity = datastore.getMappingContext().getPersistentEntity(clazz.getName());
                    shouldTrigger = persistentEntity != null && isValidSessionFactory;
                    if (shouldTrigger.booleanValue() && (previous = this.eventListeners.putIfAbsent(key, eventListener = new ClosureEventListener(persistentEntity, this.failOnError, this.failOnErrorPackages))) != null) {
                        eventListener = previous;
                    }
                    this.cachedShouldTrigger.put(key, shouldTrigger);
                }
            }
        }
        return eventListener;
    }

    @Override
    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return AbstractPersistenceEvent.class.isAssignableFrom(eventType);
    }

    @Deprecated
    public TimestampProvider getTimestampProvider() {
        return new DefaultTimestampProvider();
    }

    @Deprecated
    public void setTimestampProvider(TimestampProvider timestampProvider) {
    }
}

