/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage.change;

import com.datical.liquibase.ext.storedlogic.databasepackage.change.CreatePackageStatement;
import java.util.ArrayList;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.sqlgenerator.core.CreateProcedureGenerator;
import liquibase.structure.DatabaseObject;

public class CreatePackageGenerator
extends AbstractSqlGenerator<CreatePackageStatement> {
    @Override
    public int getPriority() {
        return 6;
    }

    @Override
    public ValidationErrors validate(CreatePackageStatement createPackageStatement, Database object, SqlGeneratorChain sqlGeneratorChain) {
        object = new ValidationErrors();
        ((ValidationErrors)object).checkRequiredField("packageName", createPackageStatement.getPackageName());
        ((ValidationErrors)object).checkRequiredField("packageText", createPackageStatement.getPackageText());
        return object;
    }

    @Override
    public Sql[] generateSql(CreatePackageStatement createPackageStatement, Database database, SqlGeneratorChain object) {
        object = ";";
        if (database instanceof OracleDatabase) {
            object = "\n/";
        } else if (database instanceof DB2Database) {
            object = "";
        }
        ArrayList<Sql> arrayList = new ArrayList<Sql>();
        arrayList.add(new UnparsedSql(CreateProcedureGenerator.addSchemaToText(CreateProcedureGenerator.removeTrailingDelimiter(createPackageStatement.getPackageText(), (String)object), createPackageStatement.getSchemaName(), "PACKAGE", database), (String)object, new DatabaseObject[0]));
        CreateProcedureGenerator.surroundWithSchemaSets(arrayList, createPackageStatement.getSchemaName(), database);
        ArrayList<Sql> arrayList2 = arrayList;
        return arrayList2.toArray(new Sql[arrayList2.size()]);
    }
}

