/*
 * Decompiled with CFR 0.152.
 */
package fr.w3blog.zpl.model.element;

import fr.w3blog.zpl.model.PrinterOptions;
import fr.w3blog.zpl.model.ZebraElement;
import fr.w3blog.zpl.utils.ZplUtils;

public class ZebraGraficBox
extends ZebraElement<ZebraGraficBox> {
    private Integer width;
    private Integer height;
    private Integer borderTickness;
    private String lineColor;

    public ZebraGraficBox(int positionX, int positionY, Integer width, Integer height, Integer borderTickness, String lineColor) {
        this.positionX = positionX;
        this.positionY = positionY;
        this.width = width;
        this.height = height;
        this.borderTickness = borderTickness;
        this.lineColor = lineColor;
    }

    @Override
    protected ZebraGraficBox getThis() {
        return this;
    }

    @Override
    public String getZplCode(PrinterOptions printerOptions) {
        StringBuilder zpl = new StringBuilder();
        zpl.append(this.getZplCodePosition());
        zpl.append("\n");
        zpl.append((CharSequence)ZplUtils.zplCommand("GB", this.width, this.height, this.borderTickness, this.lineColor));
        zpl.append("^FS");
        zpl.append("\n");
        return zpl.toString();
    }

    @Override
    protected String getZplCodePosition() {
        StringBuffer zpl = new StringBuffer("");
        if (this.positionX != null && this.positionY != null) {
            zpl.append((CharSequence)ZplUtils.zplCommand("FO", this.positionX, this.positionY));
        }
        return zpl.toString();
    }
}

