/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.custom;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.change.AbstractChange;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.custom.CustomChange;
import liquibase.change.custom.CustomSqlChange;
import liquibase.change.custom.CustomSqlRollback;
import liquibase.change.custom.CustomTaskChange;
import liquibase.change.custom.CustomTaskRollback;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.statement.SqlStatement;
import liquibase.util.ObjectUtil;

@DatabaseChange(name="customChange", description="Although Liquibase tries to provide a wide range of database refactorings, there are times you may want to create your own custom refactoring class.\n\nTo create your own custom refactoring, simply create a class that implements the liquibase.change.custom.CustomSqlChange or liquibase.change.custom.CustomTaskChange interface and use the <custom> tag in your change set.\n\nIf your change can be rolled back, implement the liquibase.change.custom.CustomSqlRollback interface as well.\n\nFor a sample custom change class, see liquibase.change.custom.ExampleCustomSqlChange", priority=1)
public class CustomChangeWrapper
extends AbstractChange {
    CustomChange customChange;
    private String className;
    private SortedSet<String> params = new TreeSet<String>();
    private Map<String, String> paramValues = new LinkedHashMap<String, String>();
    private ClassLoader classLoader;
    private boolean configured;

    @Override
    public boolean generateStatementsVolatile(Database database) {
        return true;
    }

    @DatabaseChangeProperty(isChangeProperty=false)
    public CustomChange getCustomChange() {
        return this.customChange;
    }

    @DatabaseChangeProperty(isChangeProperty=false)
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public CustomChangeWrapper setClass(String className) throws CustomChangeException {
        if (className == null) {
            return this;
        }
        if (this.classLoader == null) {
            throw new CustomChangeException("CustomChangeWrapper classLoader not set");
        }
        this.className = className;
        try {
            try {
                this.customChange = (CustomChange)Class.forName(className, true, this.classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassCastException e2) {
                try {
                    this.customChange = (CustomChange)Thread.currentThread().getContextClassLoader().loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException e1) {
                    this.customChange = (CustomChange)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
        }
        catch (Exception e3) {
            throw new CustomChangeException(e3);
        }
        return this;
    }

    @DatabaseChangeProperty(description="Name class that implements the custom change.")
    public String getClassName() {
        return this.className;
    }

    public void setParam(String name, String value) {
        this.params.add(name);
        this.paramValues.put(name, value);
    }

    @DatabaseChangeProperty(isChangeProperty=false)
    public SortedSet<String> getParams() {
        return Collections.unmodifiableSortedSet(this.params);
    }

    public String getParamValue(String key) {
        return this.paramValues.get(key);
    }

    @Override
    public ValidationErrors validate(Database database) {
        if (!this.configured) {
            try {
                this.configureCustomChange();
            }
            catch (CustomChangeException e2) {
                throw new UnexpectedLiquibaseException(e2);
            }
        }
        try {
            return this.customChange.validate(database);
        }
        catch (Exception e3) {
            return new ValidationErrors().addError("Exception thrown calling " + this.getClassName() + ".validate():" + e3.getMessage());
        }
    }

    @Override
    public Warnings warn(Database database) {
        return new Warnings();
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        SqlStatement[] statements;
        block5: {
            statements = null;
            try {
                this.configureCustomChange();
                if (this.customChange instanceof CustomSqlChange) {
                    statements = ((CustomSqlChange)this.customChange).generateStatements(database);
                    break block5;
                }
                if (this.customChange instanceof CustomTaskChange) {
                    ((CustomTaskChange)this.customChange).execute(database);
                    break block5;
                }
                throw new UnexpectedLiquibaseException(this.customChange.getClass().getName() + " does not implement " + CustomSqlChange.class.getName() + " or " + CustomTaskChange.class.getName());
            }
            catch (CustomChangeException e2) {
                throw new UnexpectedLiquibaseException(e2);
            }
        }
        if (statements == null) {
            statements = new SqlStatement[]{};
        }
        return statements;
    }

    @Override
    public SqlStatement[] generateRollbackStatements(Database database) throws RollbackImpossibleException {
        SqlStatement[] statements;
        block5: {
            statements = null;
            try {
                this.configureCustomChange();
                if (this.customChange instanceof CustomSqlRollback) {
                    statements = ((CustomSqlRollback)((Object)this.customChange)).generateRollbackStatements(database);
                    break block5;
                }
                if (this.customChange instanceof CustomTaskRollback) {
                    ((CustomTaskRollback)((Object)this.customChange)).rollback(database);
                    break block5;
                }
                throw new RollbackImpossibleException("Unknown rollback type: " + this.customChange.getClass().getName());
            }
            catch (CustomChangeException e2) {
                throw new UnexpectedLiquibaseException(e2);
            }
        }
        if (statements == null) {
            statements = new SqlStatement[]{};
        }
        return statements;
    }

    @Override
    public boolean supportsRollback(Database database) {
        return this.customChange instanceof CustomSqlRollback || this.customChange instanceof CustomTaskRollback;
    }

    @Override
    public String getConfirmationMessage() {
        try {
            this.configureCustomChange();
        }
        catch (CustomChangeException e2) {
            throw new UnexpectedLiquibaseException(e2);
        }
        return this.customChange.getConfirmationMessage();
    }

    private void configureCustomChange() throws CustomChangeException {
        if (this.configured) {
            return;
        }
        try {
            for (String param : this.params) {
                ObjectUtil.setProperty((Object)this.customChange, param, this.paramValues.get(param));
            }
            this.customChange.setFileOpener(this.getResourceAccessor());
            this.customChange.setUp();
            this.configured = true;
        }
        catch (Exception e2) {
            throw new CustomChangeException(e2);
        }
    }

    @Override
    public LiquibaseSerializable.SerializationType getSerializableFieldType(String field) {
        switch (field) {
            case "class": {
                return LiquibaseSerializable.SerializationType.NAMED_FIELD;
            }
            case "param": {
                return LiquibaseSerializable.SerializationType.NAMED_FIELD;
            }
        }
        throw new UnexpectedLiquibaseException("Unexpected CustomChangeWrapper field " + field);
    }

    @Override
    public Object getSerializableFieldValue(String field) {
        switch (field) {
            case "class": {
                return this.getClassName();
            }
            case "param": {
                return this.paramValues;
            }
        }
        throw new UnexpectedLiquibaseException("Unexpected CustomChangeWrapper field " + field);
    }

    @Override
    public Set<String> getSerializableFields() {
        return new HashSet<String>(Arrays.asList("class", "param"));
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }

    @Override
    public void load(ParsedNode parsedNode, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        this.setClassLoader(resourceAccessor.toClassLoader());
        try {
            this.setClass(parsedNode.getChildValue((String)null, "class", String.class));
        }
        catch (CustomChangeException e2) {
            throw new ParsedNodeException(e2);
        }
        super.load(parsedNode, resourceAccessor);
    }

    @Override
    public void customLoadLogic(ParsedNode parsedNode, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        ParsedNode paramsNode = parsedNode.getChild(null, "params");
        if (paramsNode == null) {
            paramsNode = parsedNode;
        }
        for (ParsedNode child : paramsNode.getChildren(null, "param")) {
            Object value = child.getValue();
            if (value == null) {
                value = child.getChildValue(null, "value");
            }
            if (value != null) {
                value = value.toString();
            }
            this.setParam(child.getChildValue((String)null, "name", String.class), (String)value);
        }
        CustomChange customChange = null;
        try {
            customChange = (CustomChange)Class.forName(this.className, false, resourceAccessor.toClassLoader()).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            throw new UnexpectedLiquibaseException(e2);
        }
        for (ParsedNode node : parsedNode.getChildren()) {
            Object value = node.getValue();
            if (value == null || !ObjectUtil.hasProperty(customChange, node.getName())) continue;
            this.setParam(node.getName(), value.toString());
        }
    }
}

