/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.wmf2svg.gdi.svg;

import net.arnx.wmf2svg.gdi.GdiBrush;
import net.arnx.wmf2svg.gdi.svg.SvgGdi;
import net.arnx.wmf2svg.gdi.svg.SvgObject;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

class SvgBrush
extends SvgObject
implements GdiBrush {
    private int style;
    private int color;
    private int hatch;

    public SvgBrush(SvgGdi gdi, int style, int color, int hatch) {
        super(gdi);
        this.style = style;
        this.color = color;
        this.hatch = hatch;
    }

    @Override
    public int getStyle() {
        return this.style;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public int getHatch() {
        return this.hatch;
    }

    public Element createFillPattern(String id) {
        Element pattern = null;
        if (this.style == 2) {
            pattern = this.getGDI().getDocument().createElement("pattern");
            pattern.setAttribute("id", id);
            pattern.setAttribute("patternUnits", "userSpaceOnUse");
            pattern.setAttribute("x", "" + this.toRealSize(0));
            pattern.setAttribute("y", "" + this.toRealSize(0));
            pattern.setAttribute("width", "" + this.toRealSize(8));
            pattern.setAttribute("height", "" + this.toRealSize(8));
            if (this.getGDI().getDC().getBkMode() == 2) {
                Element rect = this.getGDI().getDocument().createElement("rect");
                rect.setAttribute("fill", SvgBrush.toColor(this.getGDI().getDC().getBkColor()));
                rect.setAttribute("x", "" + this.toRealSize(0));
                rect.setAttribute("y", "" + this.toRealSize(0));
                rect.setAttribute("width", "" + this.toRealSize(8));
                rect.setAttribute("height", "" + this.toRealSize(8));
                pattern.appendChild(rect);
            }
            switch (this.hatch) {
                case 0: {
                    Element path = this.getGDI().getDocument().createElement("line");
                    path.setAttribute("stroke", SvgBrush.toColor(this.color));
                    path.setAttribute("x1", "" + this.toRealSize(0));
                    path.setAttribute("y1", "" + this.toRealSize(4));
                    path.setAttribute("x2", "" + this.toRealSize(8));
                    path.setAttribute("y2", "" + this.toRealSize(4));
                    pattern.appendChild(path);
                    break;
                }
                case 1: {
                    Element path = this.getGDI().getDocument().createElement("line");
                    path.setAttribute("stroke", SvgBrush.toColor(this.color));
                    path.setAttribute("x1", "" + this.toRealSize(4));
                    path.setAttribute("y1", "" + this.toRealSize(0));
                    path.setAttribute("x2", "" + this.toRealSize(4));
                    path.setAttribute("y2", "" + this.toRealSize(8));
                    pattern.appendChild(path);
                    break;
                }
                case 2: {
                    Element path = this.getGDI().getDocument().createElement("line");
                    path.setAttribute("stroke", SvgBrush.toColor(this.color));
                    path.setAttribute("x1", "" + this.toRealSize(0));
                    path.setAttribute("y1", "" + this.toRealSize(0));
                    path.setAttribute("x2", "" + this.toRealSize(8));
                    path.setAttribute("y2", "" + this.toRealSize(8));
                    pattern.appendChild(path);
                    break;
                }
                case 3: {
                    Element path = this.getGDI().getDocument().createElement("line");
                    path.setAttribute("stroke", SvgBrush.toColor(this.color));
                    path.setAttribute("x1", "" + this.toRealSize(0));
                    path.setAttribute("y1", "" + this.toRealSize(8));
                    path.setAttribute("x2", "" + this.toRealSize(8));
                    path.setAttribute("y2", "" + this.toRealSize(0));
                    pattern.appendChild(path);
                    break;
                }
                case 4: {
                    Element path1 = this.getGDI().getDocument().createElement("line");
                    path1.setAttribute("stroke", SvgBrush.toColor(this.color));
                    path1.setAttribute("x1", "" + this.toRealSize(0));
                    path1.setAttribute("y1", "" + this.toRealSize(4));
                    path1.setAttribute("x2", "" + this.toRealSize(8));
                    path1.setAttribute("y2", "" + this.toRealSize(4));
                    pattern.appendChild(path1);
                    Element path2 = this.getGDI().getDocument().createElement("line");
                    path2.setAttribute("stroke", SvgBrush.toColor(this.color));
                    path2.setAttribute("x1", "" + this.toRealSize(4));
                    path2.setAttribute("y1", "" + this.toRealSize(0));
                    path2.setAttribute("x2", "" + this.toRealSize(4));
                    path2.setAttribute("y2", "" + this.toRealSize(8));
                    pattern.appendChild(path2);
                    break;
                }
                case 5: {
                    Element path1 = this.getGDI().getDocument().createElement("line");
                    path1.setAttribute("stroke", SvgBrush.toColor(this.color));
                    path1.setAttribute("x1", "" + this.toRealSize(0));
                    path1.setAttribute("y1", "" + this.toRealSize(0));
                    path1.setAttribute("x2", "" + this.toRealSize(8));
                    path1.setAttribute("y2", "" + this.toRealSize(8));
                    pattern.appendChild(path1);
                    Element path2 = this.getGDI().getDocument().createElement("line");
                    path2.setAttribute("stroke", SvgBrush.toColor(this.color));
                    path2.setAttribute("x1", "" + this.toRealSize(0));
                    path2.setAttribute("y1", "" + this.toRealSize(8));
                    path2.setAttribute("x2", "" + this.toRealSize(8));
                    path2.setAttribute("y2", "" + this.toRealSize(0));
                    pattern.appendChild(path2);
                }
            }
        }
        return pattern;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.color;
        result = 31 * result + this.hatch;
        result = 31 * result + this.style;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SvgBrush other = (SvgBrush)obj;
        if (this.color != other.color) {
            return false;
        }
        if (this.hatch != other.hatch) {
            return false;
        }
        return this.style == other.style;
    }

    public Text createTextNode(String id) {
        return this.getGDI().getDocument().createTextNode("." + id + " { " + this.toString() + " }\n");
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        switch (this.style) {
            case 0: {
                buffer.append("fill: ").append(SvgBrush.toColor(this.color)).append("; ");
                break;
            }
            case 2: {
                break;
            }
            default: {
                buffer.append("fill: none; ");
            }
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }
}

