/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;
import org.docx4j.TraversalUtil;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPartXPathAware;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.AltChunkInterface;
import org.docx4j.openpackaging.parts.WordprocessingML.AltChunkType;
import org.docx4j.openpackaging.parts.WordprocessingML.AlternativeFormatInputPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.utils.AltChunkFinder;
import org.docx4j.wml.CTAltChunk;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JaxbXmlPartAltChunkHost<E>
extends JaxbXmlPartXPathAware<E>
implements AltChunkInterface {
    protected static Logger log = LoggerFactory.getLogger(JaxbXmlPartAltChunkHost.class);

    public JaxbXmlPartAltChunkHost(PartName partName) throws InvalidFormatException {
        super(partName);
    }

    @Override
    public AlternativeFormatInputPart addAltChunk(AltChunkType type, byte[] bytes) throws Docx4JException {
        return this.addAltChunk(type, bytes, -1);
    }

    @Override
    public AlternativeFormatInputPart addAltChunk(AltChunkType type, byte[] bytes, int index) throws Docx4JException {
        AlternativeFormatInputPart afiPart = new AlternativeFormatInputPart(type);
        Relationship altChunkRel = this.addTargetPart((Part)afiPart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
        afiPart.registerInContentTypeManager();
        afiPart.setBinaryData(bytes);
        CTAltChunk ac = Context.getWmlObjectFactory().createCTAltChunk();
        ac.setId(altChunkRel.getId());
        if (this instanceof ContentAccessor) {
            if (index < 0) {
                ((ContentAccessor)this).getContent().add(ac);
            } else {
                ((ContentAccessor)this).getContent().add(index, ac);
            }
        } else {
            throw new Docx4JException(this.getClass().getName() + " doesn't implement ContentAccessor");
        }
        return afiPart;
    }

    @Override
    public AlternativeFormatInputPart addAltChunk(AltChunkType type, InputStream is) throws Docx4JException {
        return this.addAltChunk(type, is, -1);
    }

    @Override
    public AlternativeFormatInputPart addAltChunk(AltChunkType type, InputStream is, int index) throws Docx4JException {
        AlternativeFormatInputPart afiPart = new AlternativeFormatInputPart(type);
        Relationship altChunkRel = this.addTargetPart((Part)afiPart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
        afiPart.registerInContentTypeManager();
        afiPart.setBinaryData(is);
        CTAltChunk ac = Context.getWmlObjectFactory().createCTAltChunk();
        ac.setId(altChunkRel.getId());
        if (this instanceof ContentAccessor) {
            if (index < 0) {
                ((ContentAccessor)this).getContent().add(ac);
            } else {
                ((ContentAccessor)this).getContent().add(index, ac);
            }
        } else {
            throw new Docx4JException(this.getClass().getName() + " doesn't implement ContentAccessor");
        }
        return afiPart;
    }

    @Override
    public AlternativeFormatInputPart addAltChunk(AltChunkType type, byte[] bytes, ContentAccessor attachmentPoint) throws Docx4JException {
        return this.addAltChunk(type, bytes, attachmentPoint, -1);
    }

    @Override
    public AlternativeFormatInputPart addAltChunk(AltChunkType type, byte[] bytes, ContentAccessor attachmentPoint, int index) throws Docx4JException {
        AlternativeFormatInputPart afiPart = new AlternativeFormatInputPart(type);
        Relationship altChunkRel = this.addTargetPart((Part)afiPart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
        afiPart.registerInContentTypeManager();
        afiPart.setBinaryData(bytes);
        CTAltChunk ac = Context.getWmlObjectFactory().createCTAltChunk();
        ac.setId(altChunkRel.getId());
        if (index < 0) {
            attachmentPoint.getContent().add(ac);
        } else {
            attachmentPoint.getContent().add(index, ac);
        }
        return afiPart;
    }

    @Override
    public AlternativeFormatInputPart addAltChunk(AltChunkType type, InputStream is, ContentAccessor attachmentPoint) throws Docx4JException {
        return this.addAltChunk(type, is, attachmentPoint, -1);
    }

    @Override
    public AlternativeFormatInputPart addAltChunk(AltChunkType type, InputStream is, ContentAccessor attachmentPoint, int index) throws Docx4JException {
        AlternativeFormatInputPart afiPart = new AlternativeFormatInputPart(type);
        Relationship altChunkRel = this.addTargetPart((Part)afiPart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
        afiPart.registerInContentTypeManager();
        afiPart.setBinaryData(is);
        CTAltChunk ac = Context.getWmlObjectFactory().createCTAltChunk();
        ac.setId(altChunkRel.getId());
        if (index < 0) {
            attachmentPoint.getContent().add(ac);
        } else {
            attachmentPoint.getContent().add(index, ac);
        }
        return afiPart;
    }

    @Override
    public void convertAltChunks() throws Docx4JException {
        if (!(this instanceof ContentAccessor)) {
            throw new Docx4JException(this.getClass().getName() + " doesn't implement ContentAccessor");
        }
        PartName partName = this.getPartName();
        List contentList = ((ContentAccessor)this).getContent();
        AltChunkFinder bf = new AltChunkFinder();
        new TraversalUtil(contentList, bf);
        boolean encounteredDocxAltChunk = false;
        log.info("Detected " + bf.getAltChunks().size());
        for (AltChunkFinder.LocatedChunk locatedChunk : bf.getAltChunks()) {
            boolean deleteThisAltChunk = false;
            CTAltChunk altChunk = locatedChunk.getAltChunk();
            AlternativeFormatInputPart afip = (AlternativeFormatInputPart)this.getRelationshipsPart().getPart(altChunk.getId());
            AltChunkType type = afip.getAltChunkType();
            if (type == null) {
                log.warn("Unrecognized type for part " + afip.getPartName().getName());
            } else if (type.equals((Object)AltChunkType.Xhtml) || type.equals((Object)AltChunkType.Mht)) {
                Object xHTMLImporter = null;
                Method convertMethod = null;
                try {
                    Class<?> xhtmlImporterClass = Class.forName("org.docx4j.convert.in.xhtml.XHTMLImporterImpl");
                    Constructor<?> ctor = xhtmlImporterClass.getConstructor(WordprocessingMLPackage.class);
                    xHTMLImporter = ctor.newInstance(this.getPackage());
                    convertMethod = type.equals((Object)AltChunkType.Xhtml) ? xhtmlImporterClass.getMethod("convert", InputStream.class, String.class) : xhtmlImporterClass.getMethod("convertMHT", InputStream.class, String.class);
                    if (convertMethod == null) {
                        throw new Docx4JException("XHTMLImporterImpl convertMethod not found");
                    }
                }
                catch (Exception e) {
                    log.warn("docx4j-XHTMLImport jar not found. Please add this to your classpath.");
                    log.warn(e.getMessage(), (Throwable)e);
                    return;
                }
                List results = null;
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(afip.getBytes());
                    results = (List)convertMethod.invoke(xHTMLImporter, bais, null);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    continue;
                }
                int index = locatedChunk.getIndex();
                locatedChunk.getContentList().remove(index);
                locatedChunk.getContentList().addAll(index, results);
                log.info(afip.getPartName().getName() + "; Converted altChunk of type XHTML ");
                deleteThisAltChunk = true;
            } else {
                if (type.equals((Object)AltChunkType.Xml)) {
                    log.warn(afip.getPartName().getName() + " is AltChunkType.Xml; assuming this is Flat OPC XML, use Docx4j Enterprise MergeDocx to convert this.");
                    continue;
                }
                if (type.equals((Object)AltChunkType.TextPlain)) {
                    String result = null;
                    try {
                        result = this.toString(afip.getBuffer());
                    }
                    catch (UnsupportedEncodingException e) {
                        log.error(e.getMessage(), (Throwable)e);
                        continue;
                    }
                    if (result != null) {
                        int index = locatedChunk.getIndex();
                        locatedChunk.getContentList().remove(index);
                        ObjectFactory factory = Context.getWmlObjectFactory();
                        P para = factory.createP();
                        locatedChunk.getContentList().add(index, para);
                        R run = factory.createR();
                        para.getContent().add(run);
                        Text t = factory.createText();
                        t.setValue(result);
                        run.getContent().add(t);
                        log.info(afip.getPartName().getName() + "; Converted altChunk of type text ");
                        deleteThisAltChunk = true;
                    }
                } else {
                    if (type.equals((Object)AltChunkType.WordprocessingML) || type.equals((Object)AltChunkType.OfficeWordMacroEnabled) || type.equals((Object)AltChunkType.OfficeWordTemplate) || type.equals((Object)AltChunkType.OfficeWordMacroEnabledTemplate)) {
                        log.warn(afip.getPartName().getName() + " is " + type.getContentType() + "; use Docx4j Enterprise MergeDocx to convert this.");
                        continue;
                    }
                    if (type.equals((Object)AltChunkType.Rtf)) {
                        log.warn(afip.getPartName().getName() + "; skipping altChunk of type RTF ");
                        continue;
                    }
                    if (type.equals((Object)AltChunkType.Html)) {
                        log.warn(afip.getPartName().getName() + "; skipping altChunk of type HTML ");
                        continue;
                    }
                }
            }
            if (!deleteThisAltChunk) continue;
            this.getRelationshipsPart().removePart(afip.getPartName());
        }
    }

    private void extensionMissing(Exception e) {
        log.warn("\n" + e.getClass().getName() + ": " + e.getMessage() + "\n");
        log.warn("* Skipping altChunk of type docx ");
        log.warn("* You don't appear to have the MergeDocx extension,");
        log.warn("* which is necessary to merge docx, or process altChunk.");
        log.warn("* MergeDocx is part of the Enterprise Edition of docx4j.");
        log.warn("* Please email sales@plutext.com or visit www.plutext.com if you want to try it.");
    }

    private String toString(ByteBuffer bb) throws UnsupportedEncodingException {
        byte[] bytes = null;
        bytes = new byte[bb.limit()];
        bb.get(bytes);
        return new String(bytes, "UTF-8");
    }
}

