/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.properties.paragraph;

import java.math.BigInteger;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.jaxb.Context;
import org.docx4j.model.properties.paragraph.AbstractParagraphProperty;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class LineSpacing
extends AbstractParagraphProperty {
    protected static Logger log = LoggerFactory.getLogger(LineSpacing.class);
    public static final String CSS_NAME = "line-height";
    public static final String FO_NAME = "line-height";
    int MAGIC_NUMBER = 240;

    @Override
    public String getCssName() {
        return "line-height";
    }

    public LineSpacing(BigInteger val) {
        this.setObject(val);
    }

    public LineSpacing(CSSValue value) {
        int twip;
        this.debug("line-height", value);
        CSSPrimitiveValue cssPrimitiveValue = (CSSPrimitiveValue)value;
        short ignored = 1;
        float fVal = cssPrimitiveValue.getFloatValue(ignored);
        short type = cssPrimitiveValue.getPrimitiveType();
        if (8 == type) {
            twip = UnitsOfMeasurement.inchToTwip(fVal);
        } else if (7 == type) {
            twip = UnitsOfMeasurement.mmToTwip(fVal);
        } else if (2 == type) {
            twip = this.twipFromPercentage(fVal);
        } else {
            if (21 == type) {
                if (value.getCssText().equals("normal")) {
                    return;
                }
                log.error("TODO: handle value: " + value.getCssText());
                return;
            }
            if (3 == type) {
                twip = UnitsOfMeasurement.pxToTwip(16.0f * fVal);
            } else if (4 == type) {
                twip = UnitsOfMeasurement.pxToTwip(8.0f * fVal);
            } else if (1 == type) {
                twip = UnitsOfMeasurement.pxToTwip(16.0f * fVal);
            } else {
                log.error("No support for unit " + type);
                return;
            }
        }
        this.setObject(BigInteger.valueOf(twip));
    }

    private int twipFromPercentage(float fVal) {
        return Math.round((float)this.MAGIC_NUMBER * fVal / 100.0f);
    }

    private int twipToPercentage(int val) {
        return Math.round(100 * val / this.MAGIC_NUMBER);
    }

    @Override
    public String getCssProperty() {
        return LineSpacing.composeCss("line-height", this.twipToPercentage(((BigInteger)this.getObject()).intValue()) + "%");
    }

    @Override
    public void setXslFO(Element foElement) {
        foElement.setAttribute("line-height", this.twipToPercentage(((BigInteger)this.getObject()).intValue()) + "%");
    }

    @Override
    public void set(PPr pPr) {
        if (pPr.getSpacing() == null) {
            PPrBase.Spacing spacing = Context.getWmlObjectFactory().createPPrBaseSpacing();
            pPr.setSpacing(spacing);
        }
        pPr.getSpacing().setLine((BigInteger)this.getObject());
    }
}

