/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.synonym;

import com.datical.liquibase.ext.appdba.synonym.Synonym;
import com.datical.liquibase.ext.appdba.synonym.change.CreateSynonymChange;
import com.datical.liquibase.ext.license.LicenseCheckingChangeGenerator;
import liquibase.change.Change;
import liquibase.change.core.OutputChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.license.LicenseServiceUtils;
import liquibase.structure.AbstractDatabaseObject;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.StoredProcedure;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;
import liquibase.util.StringUtils;

public class MissingSynonymChangeGenerator
extends LicenseCheckingChangeGenerator
implements MissingObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (Synonym.class.isAssignableFrom(clazz)) {
            if (!LicenseServiceUtils.checkForValidLicense("Liquibase Pro")) {
                return -1;
            }
            return 1;
        }
        return -1;
    }

    @Override
    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[]{Table.class, View.class, StoredProcedure.class};
    }

    @Override
    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return new Class[]{ForeignKey.class, Index.class};
    }

    @Override
    public Change[] fixMissing(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database database, Database object, ChangeGeneratorChain object2) {
        object2 = (Synonym)databaseObject;
        CreateSynonymChange createSynonymChange = new CreateSynonymChange();
        createSynonymChange.setSynonymName(((Synonym)object2).getName());
        createSynonymChange.setObjectName(((Synonym)object2).getObjectName());
        boolean bl2 = ((Synonym)object2).isPrivate();
        if (object instanceof MSSQLDatabase) {
            bl2 = true;
        }
        createSynonymChange.setPrivate(bl2);
        createSynonymChange.setObjectType(((Synonym)object2).getObjectType());
        if (bl2 && ((Synonym)object2).getSchema() != null) {
            if (diffOutputControl.getIncludeCatalog()) {
                createSynonymChange.setSynonymCatalogName(((Synonym)object2).getSchema().getCatalogName());
            }
            if (diffOutputControl.getIncludeSchema()) {
                createSynonymChange.setSynonymSchemaName(((Synonym)object2).getSchema().getName());
            }
        }
        if (((Synonym)object2).getObjectSchema() != null) {
            boolean bl3;
            object = (String)((Object)((AbstractDatabaseObject)object2).getAttribute("_actualObjectCatalogName", String.class));
            if (object == null) {
                object = ((Synonym)object2).getObjectSchema().getCatalogName();
            }
            bl2 = !StringUtils.trimToEmpty((String)object).equalsIgnoreCase(StringUtils.trimToEmpty(database.getDefaultCatalogName()));
            boolean bl4 = bl3 = !StringUtils.trimToEmpty(((Synonym)object2).getObjectSchema().getName()).equalsIgnoreCase(StringUtils.trimToEmpty(database.getDefaultSchemaName()));
            if (bl2 || diffOutputControl.getIncludeCatalog()) {
                createSynonymChange.setObjectCatalogName((String)object);
            }
            if (bl3 || diffOutputControl.getIncludeSchema()) {
                createSynonymChange.setObjectSchemaName(((Synonym)object2).getObjectSchema().getName());
            }
        }
        if (database instanceof OracleDatabase && createSynonymChange.getSynonymCatalogName() != null && createSynonymChange.getSynonymSchemaName() == null) {
            CreateSynonymChange createSynonymChange2 = createSynonymChange;
            createSynonymChange2.setSynonymSchemaName(createSynonymChange2.getSynonymCatalogName());
            createSynonymChange.setSynonymCatalogName(null);
        }
        if (database instanceof OracleDatabase && createSynonymChange.getObjectCatalogName() != null && createSynonymChange.getObjectSchemaName() == null) {
            CreateSynonymChange createSynonymChange3 = createSynonymChange;
            createSynonymChange3.setObjectSchemaName(createSynonymChange3.getObjectCatalogName());
            createSynonymChange.setObjectCatalogName(null);
        }
        if (database instanceof OracleDatabase && databaseObject.getAttribute("missingSchema", Boolean.FALSE).booleanValue()) {
            object = new OutputChange();
            ((OutputChange)object).setMessage("No schema found for the object pointed to by this synonym. This may mean it references an object across database link. Please ensure the synonym is being created correctly.");
            return new Change[]{object, createSynonymChange};
        }
        return new Change[]{createSynonymChange};
    }
}

