/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.sql.SQLException;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.NotLongDataParameter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;

public class StringParameter
extends NotLongDataParameter
implements Cloneable {
    private String stringValue;
    private boolean noBackslashEscapes;
    private byte[] escapedArray = null;
    private int position;
    private int charsOffset;
    private boolean binary;

    public StringParameter(String str, boolean noBackslashEscapes) throws SQLException {
        this.stringValue = str;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    @Override
    public void writeTo(PacketOutputStream os) {
        if (this.escapedArray == null) {
            this.escapeUtf8();
        }
        os.write(this.escapedArray, 0, this.position);
    }

    @Override
    public void writeUnsafeTo(PacketOutputStream os) {
        if (this.escapedArray == null) {
            this.escapeUtf8();
        }
        os.buffer.put(this.escapedArray, 0, this.position);
    }

    @Override
    public long getApproximateTextProtocolLength() {
        if (this.escapedArray == null) {
            this.escapeUtf8();
        }
        return this.position;
    }

    @Override
    public void writeBinary(PacketOutputStream writer) {
        if (this.escapedArray == null) {
            this.utf8();
        }
        writer.assureBufferCapacity(this.position + 9);
        writer.writeFieldLength(this.position);
        writer.buffer.put(this.escapedArray, 0, this.position);
        this.escapedArray = null;
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.VARCHAR;
    }

    @Override
    public String toString() {
        if (this.stringValue != null) {
            if (this.stringValue.length() < 1024) {
                return "'" + this.stringValue + "'";
            }
            return "'" + this.stringValue.substring(0, 1024) + "...'";
        }
        if (this.position > 1024) {
            if (this.binary) {
                return "'" + new String(this.escapedArray, 0, 1024) + "...'";
            }
            return new String(this.escapedArray, 0, 1024) + "...'";
        }
        if (this.binary) {
            return "'" + new String(this.escapedArray, 0, this.position) + "'";
        }
        return new String(this.escapedArray, 0, this.position);
    }

    private void escapeUtf8() {
        char charValue;
        int charsLength = this.stringValue.length();
        this.charsOffset = 0;
        this.position = 0;
        if (charsLength == 0) {
            this.position = 2;
            this.escapedArray = new byte[]{39, 39};
            return;
        }
        this.escapedArray = new byte[charsLength * 3 + 2];
        this.escapedArray[this.position++] = 39;
        if (this.noBackslashEscapes) {
            while ((charValue = this.stringValue.charAt(this.charsOffset)) < '\u0080') {
                if (charValue == '\'') {
                    this.escapedArray[this.position++] = 39;
                }
                this.escapedArray[this.position++] = (byte)charValue;
                ++this.charsOffset;
                if (this.charsOffset < charsLength) continue;
                break;
            }
        } else {
            while ((charValue = this.stringValue.charAt(this.charsOffset)) < '\u0080') {
                if (charValue == '\'' || charValue == '\\' || charValue == '\"' || charValue == '\u0000') {
                    this.escapedArray[this.position++] = 92;
                }
                this.escapedArray[this.position++] = (byte)charValue;
                ++this.charsOffset;
                if (this.charsOffset < charsLength) continue;
            }
        }
        while (this.charsOffset < charsLength) {
            char currChar;
            if ((currChar = this.stringValue.charAt(this.charsOffset++)) < '\u0080') {
                if (currChar == '\'') {
                    this.escapedArray[this.position++] = this.noBackslashEscapes ? 39 : 92;
                } else if (!(this.noBackslashEscapes || currChar != '\\' && currChar != '\"' && currChar != '\u0000')) {
                    this.escapedArray[this.position++] = 92;
                }
                this.escapedArray[this.position++] = (byte)currChar;
                continue;
            }
            this.getNonAsciiByte(currChar, this.stringValue, charsLength);
        }
        this.escapedArray[this.position++] = 39;
        this.stringValue = null;
        this.binary = false;
    }

    private void getNonAsciiByte(char currChar, String stringValue, int charsLength) {
        if (currChar < '\u0800') {
            this.escapedArray[this.position++] = (byte)(0xC0 | currChar >> 6);
            this.escapedArray[this.position++] = (byte)(0x80 | currChar & 0x3F);
        } else if (currChar >= '\ud800' && currChar < '\ue000') {
            if (currChar >= '\ud800' && currChar < '\udc00') {
                if (this.charsOffset + 1 > charsLength) {
                    this.escapedArray[this.position++] = 99;
                    return;
                }
                char nextChar = stringValue.charAt(this.charsOffset);
                if (nextChar >= '\udc00' && nextChar < '\ue000') {
                    int surrogatePairs = (currChar << 10) + nextChar + -56613888;
                    this.escapedArray[this.position++] = (byte)(0xF0 | surrogatePairs >> 18);
                    this.escapedArray[this.position++] = (byte)(0x80 | surrogatePairs >> 12 & 0x3F);
                    this.escapedArray[this.position++] = (byte)(0x80 | surrogatePairs >> 6 & 0x3F);
                    this.escapedArray[this.position++] = (byte)(0x80 | surrogatePairs & 0x3F);
                    ++this.charsOffset;
                } else {
                    this.escapedArray[this.position++] = 99;
                }
            } else {
                this.escapedArray[this.position++] = 99;
            }
        } else {
            this.escapedArray[this.position++] = (byte)(0xE0 | currChar >> 12);
            this.escapedArray[this.position++] = (byte)(0x80 | currChar >> 6 & 0x3F);
            this.escapedArray[this.position++] = (byte)(0x80 | currChar & 0x3F);
        }
    }

    private void utf8() {
        int charsLength = this.stringValue.length();
        this.charsOffset = 0;
        this.position = 0;
        this.escapedArray = new byte[charsLength * 3];
        while (this.charsOffset < charsLength) {
            char currChar;
            if ((currChar = this.stringValue.charAt(this.charsOffset++)) < '\u0080') {
                this.escapedArray[this.position++] = (byte)currChar;
                continue;
            }
            this.getNonAsciiByte(currChar, this.stringValue, charsLength);
        }
        this.binary = true;
    }
}

