
<%@ page import="org.pih.warehouse.core.Organization" %>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <meta name="layout" content="custom" />
        <g:set var="entityName" value="${warehouse.message(code: 'organization.label', default: 'Organization')}" />
        <title><warehouse:message code="default.show.label" args="[entityName]" /></title>
    </head>
    <body>
        <div class="body">
            <g:if test="${flash.message}">
	            <div class="message">${flash.message}</div>
            </g:if>

            <div class="button-bar">
                <g:link class="button" action="list">
                    <img src="${resource(dir: 'images/icons/silk', file: 'application_side_list.png')}" />&nbsp;
                    <warehouse:message code="default.list.label" args="[g.message(code:'organizations.label')]"/>
                </g:link>
                <g:link class="button" action="create" params="[partyType:'ORG']">
                    <img src="${resource(dir: 'images/icons/silk', file: 'add.png')}" />&nbsp;
                    <warehouse:message code="default.add.label" args="[g.message(code:'organization.label')]"/>
                </g:link>
            </div>

            <div class="box">
                <h2><warehouse:message code="default.show.label" args="[entityName]" /></h2>
                <table>
                    <tbody>

                        <tr class="prop">
                            <td valign="top" class="name"><warehouse:message code="organization.id.label" default="Id" /></td>

                            <td valign="top" class="value">${fieldValue(bean: organizationInstance, field: "id")}</td>

                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name"><warehouse:message code="organization.partyType.label" default="Party Type" /></td>

                            <td valign="top" class="value"><g:link controller="partyType" action="show" id="${organizationInstance?.partyType?.id}">${organizationInstance?.partyType}</g:link></td>

                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name"><warehouse:message code="organization.name.label" default="Name" /></td>

                            <td valign="top" class="value">${fieldValue(bean: organizationInstance, field: "name")}</td>

                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name"><warehouse:message code="organization.description.label" default="Description" /></td>

                            <td valign="top" class="value">${fieldValue(bean: organizationInstance, field: "description")}</td>

                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name"><warehouse:message code="organization.dateCreated.label" default="Date Created" /></td>

                            <td valign="top" class="value"><format:datetime obj="${organizationInstance?.dateCreated}" /></td>

                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name"><warehouse:message code="organization.lastUpdated.label" default="Last Updated" /></td>

                            <td valign="top" class="value"><format:datetime obj="${organizationInstance?.lastUpdated}" /></td>

                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name"><warehouse:message code="organization.roles.label" default="Roles" /></td>

                            <td valign="top" style="text-align: left;" class="value">
                                <ul>
                                <g:each in="${organizationInstance.roles}" var="r">
                                    <li><g:link controller="partyRole" action="show" id="${r.id}">${r}</g:link></li>
                                </g:each>
                                </ul>
                            </td>

                        </tr>


						<tr class="prop">
                        	<td valign="top"></td>
                        	<td valign="top">
					            <div class="buttons left">
					                <g:form>
					                    <g:hiddenField name="id" value="${organizationInstance?.id}" />
					                    <g:actionSubmit class="edit" action="edit" value="${warehouse.message(code: 'default.button.edit.label', default: 'Edit')}" />
					                    <g:actionSubmit class="delete" action="delete" value="${warehouse.message(code: 'default.button.delete.label', default: 'Delete')}" onclick="return confirm('${warehouse.message(code: 'default.button.delete.confirm.message', default: 'Are you sure?')}');" />
					                </g:form>
					            </div>
							</td>
						</tr>
                    </tbody>
                </table>
            </div>
        </div>
    </body>
</html>
