/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core.utils;

import fr.opensagres.poi.xwpf.converter.core.Color;
import fr.opensagres.poi.xwpf.converter.core.TableCellBorder;
import fr.opensagres.poi.xwpf.converter.core.TableWidth;
import fr.opensagres.poi.xwpf.converter.core.utils.ColorHelper;
import fr.opensagres.poi.xwpf.converter.core.utils.DxaUtil;
import fr.opensagres.poi.xwpf.converter.core.utils.XWPFUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblCellMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGrid;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGridCol;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblLook;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTrPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class XWPFTableUtil {
    private static final String MAIN_NAMESPACE = "http://schemas.openxmlformats.org/wordprocessingml/2006/main";
    public static final int DEFAULT_TBLLOOK = 0;
    public static final int APPLY_FIRST_ROW_CONDITIONNAL_FORMATTING = 32;
    public static final int APPLY_LAST_ROW_CONDITIONNAL_FORMATTING = 64;
    public static final int APPLY_FIRST_COLUMN_CONDITIONNAL_FORMATTING = 128;
    public static final int APPLY_LAST_COLUMN_CONDITIONNAL_FORMATTING = 256;
    public static final int DO_NOT_APPLY_ROW_BANDING_CONDITIONNAL_FORMATTING = 512;
    public static final int DO_NOT_APPLY_COLUMN_BANDING_CONDITIONNAL_FORMATTING = 1024;

    public static float[] computeColWidths(CTTbl table) {
        int nbColumnsToIgnoreBefore;
        CTTblGrid grid = table.getTblGrid();
        List<CTTblGridCol> cols = XWPFTableUtil.getGridColList(grid);
        int nbColumns = cols.size();
        float[] colWidths = new float[nbColumns];
        for (int i = nbColumnsToIgnoreBefore = 0; i < colWidths.length; ++i) {
            CTTblGridCol tblGridCol = cols.get(i);
            colWidths[i] = DxaUtil.dxa2points(tblGridCol.xgetW());
        }
        return colWidths;
    }

    public static float[] computeColWidths(XWPFTable table) {
        CTTblGrid grid;
        List<CTTblGridCol> cols;
        XWPFTableRow firstRow = XWPFTableUtil.getFirstRow(table);
        int nbCols = XWPFTableUtil.getNumberOfColumns(firstRow);
        if (nbCols > (cols = XWPFTableUtil.getGridColList(grid = table.getCTTbl().getTblGrid())).size()) {
            Collection<Float> maxColWidths = null;
            Collection<Float> currentColWidths = null;
            List rows = table.getRows();
            for (Object row : rows) {
                currentColWidths = XWPFTableUtil.computeColWidths((XWPFTableRow)row);
                if (maxColWidths == null) {
                    maxColWidths = currentColWidths;
                    continue;
                }
                if (currentColWidths.size() <= maxColWidths.size()) continue;
                maxColWidths = currentColWidths;
            }
            float[] colWidths = new float[maxColWidths.size()];
            int i = 0;
            for (Float colWidth : maxColWidths) {
                colWidths[i++] = colWidth.floatValue();
            }
            return colWidths;
        }
        int nbColumnsToIgnoreBefore = XWPFTableUtil.getNbColumnsToIgnore(firstRow, true);
        int nbColumnsToIgnoreAfter = XWPFTableUtil.getNbColumnsToIgnore(firstRow, false);
        int nbColumns = cols.size() - nbColumnsToIgnoreBefore - nbColumnsToIgnoreAfter;
        float[] colWidths = new float[nbColumns];
        for (int i = nbColumnsToIgnoreBefore; i < colWidths.length; ++i) {
            CTTblGridCol tblGridCol = cols.get(i);
            colWidths[i] = DxaUtil.dxa2points(tblGridCol.xgetW());
        }
        return colWidths;
    }

    private static List<CTTblGridCol> getGridColList(CTTblGrid grid) {
        ArrayList<CTTblGridCol> newCols = new ArrayList<CTTblGridCol>();
        List cols = grid.getGridColList();
        for (CTTblGridCol col : cols) {
            if (!(XWPFUtils.floatValue(col.xgetW()) >= 0.0f)) continue;
            newCols.add(col);
        }
        return newCols;
    }

    private static int getNbColumnsToIgnore(XWPFTableRow row, boolean before) {
        List gridBeforeAfters;
        CTTrPr trPr = row.getCtRow().getTrPr();
        if (trPr == null) {
            return 0;
        }
        List list = gridBeforeAfters = before ? trPr.getGridBeforeList() : trPr.getGridAfterList();
        if (gridBeforeAfters == null || gridBeforeAfters.size() < 1) {
            return 0;
        }
        int nbColumns = 0;
        BigInteger val = null;
        for (CTDecimalNumber gridBeforeAfter : gridBeforeAfters) {
            val = gridBeforeAfter.getVal();
            if (val == null) continue;
            nbColumns += val.intValue();
        }
        return nbColumns;
    }

    public static int getNumberOfColumns(XWPFTableRow row) {
        if (row == null) {
            return 0;
        }
        int nbCols = 0;
        List tableCellsOffFirstRow = row.getTableCells();
        for (XWPFTableCell tableCellOffFirstRow : tableCellsOffFirstRow) {
            CTDecimalNumber gridSpan = XWPFTableUtil.getGridSpan(tableCellOffFirstRow);
            if (gridSpan != null) {
                nbCols += gridSpan.getVal().intValue();
                continue;
            }
            ++nbCols;
        }
        return nbCols;
    }

    public static XWPFTableRow getFirstRow(XWPFTable table) {
        int numberOfRows = table.getNumberOfRows();
        if (numberOfRows > 0) {
            return table.getRow(0);
        }
        return null;
    }

    public static CTDecimalNumber getGridSpan(XWPFTableCell cell) {
        if (cell.getCTTc().getTcPr() != null) {
            return cell.getCTTc().getTcPr().getGridSpan();
        }
        return null;
    }

    public static CTTblWidth getWidth(XWPFTableCell cell) {
        return cell.getCTTc().getTcPr().getTcW();
    }

    private static Collection<Float> computeColWidths(XWPFTableRow row) {
        ArrayList<Float> colWidths = new ArrayList<Float>();
        List cells = row.getTableCells();
        for (XWPFTableCell cell : cells) {
            CTTblWidth width = XWPFTableUtil.getWidth(cell);
            if (width == null) continue;
            int nb = 1;
            CTDecimalNumber gridSpan = XWPFTableUtil.getGridSpan(cell);
            TableWidth tableCellWidth = XWPFTableUtil.getTableWidth(cell);
            if (gridSpan != null) {
                nb = gridSpan.getVal().intValue();
            }
            for (int i = 0; i < nb; ++i) {
                colWidths.add(Float.valueOf(tableCellWidth.width / (float)nb));
            }
        }
        return colWidths;
    }

    public static TableWidth getTableWidth(XWPFTable table) {
        float width = 0.0f;
        boolean percentUnit = false;
        CTTblPr tblPr = table.getCTTbl().getTblPr();
        if (tblPr.isSetTblW()) {
            CTTblWidth tblWidth = tblPr.getTblW();
            return XWPFTableUtil.getTableWidth(tblWidth);
        }
        return new TableWidth(width, percentUnit);
    }

    public static TableWidth getTableWidth(XWPFTableCell cell) {
        float width = 0.0f;
        boolean percentUnit = false;
        CTTcPr tblPr = cell.getCTTc().getTcPr();
        if (tblPr.isSetTcW()) {
            CTTblWidth tblWidth = tblPr.getTcW();
            return XWPFTableUtil.getTableWidth(tblWidth);
        }
        return new TableWidth(width, percentUnit);
    }

    public static TableWidth getTableWidth(CTTblWidth tblWidth) {
        if (tblWidth == null) {
            return null;
        }
        Float width = XWPFTableUtil.getTblWidthW(tblWidth);
        if (width == null) {
            return null;
        }
        boolean percentUnit = 2 == tblWidth.getType().intValue();
        width = percentUnit ? Float.valueOf(width.floatValue() / 100.0f) : Float.valueOf(DxaUtil.dxa2points(width.floatValue()));
        return new TableWidth(width.floatValue(), percentUnit);
    }

    public static Float getTblWidthW(CTTblWidth tblWidth) {
        try {
            return Float.valueOf(XWPFUtils.floatValue(tblWidth.xgetW()));
        }
        catch (Throwable e) {
            Attr attr = (Attr)tblWidth.getDomNode().getAttributes().getNamedItemNS(MAIN_NAMESPACE, "w");
            if (attr != null) {
                return Float.valueOf(attr.getValue());
            }
            return null;
        }
    }

    public static CTTblPr getTblPr(XWPFTable table) {
        CTTbl tbl = table.getCTTbl();
        if (tbl != null) {
            return tbl.getTblPr();
        }
        return null;
    }

    public static CTTblBorders getTblBorders(XWPFTable table) {
        CTTblPr tblPr = XWPFTableUtil.getTblPr(table);
        if (tblPr != null) {
            return tblPr.getTblBorders();
        }
        return null;
    }

    public static CTTblCellMar getTblCellMar(XWPFTable table) {
        CTTblPr tblPr = XWPFTableUtil.getTblPr(table);
        if (tblPr != null) {
            return tblPr.getTblCellMar();
        }
        return null;
    }

    public static TableCellBorder getTableCellBorder(CTBorder border, boolean fromTableCell) {
        if (border != null) {
            boolean noBorder;
            if (STBorder.NONE == border.getVal() && fromTableCell) {
                return null;
            }
            boolean bl = noBorder = STBorder.NIL == border.getVal();
            if (noBorder) {
                return new TableCellBorder(false, fromTableCell);
            }
            Float borderSize = null;
            BigInteger size = border.getSz();
            borderSize = size != null ? Float.valueOf(size.floatValue() / 8.0f) : Float.valueOf(0.25f);
            Color borderColor = ColorHelper.getBorderColor(border);
            return new TableCellBorder(borderSize, borderColor, fromTableCell);
        }
        return null;
    }

    public static Color getBorderColor(CTBorder border) {
        if (border == null) {
            return null;
        }
        Node colorAttr = border.getDomNode().getAttributes().getNamedItemNS(MAIN_NAMESPACE, "color");
        if (colorAttr != null) {
            STBorder.Enum val = border.getVal();
            return ColorHelper.getColor(((Attr)colorAttr).getValue(), (Object)val, false);
        }
        return null;
    }

    public static CTTblLook getTblLook(XWPFTable table) {
        CTTblPr tblPr = XWPFTableUtil.getTblPr(table);
        if (tblPr != null) {
            return tblPr.getTblLook();
        }
        return null;
    }

    public static int getTblLookVal(XWPFTable table) {
        Attr attr;
        int tblLook = 0;
        CTTblLook hexNumber = XWPFTableUtil.getTblLook(table);
        if (hexNumber != null && !hexNumber.isNil() && (attr = (Attr)hexNumber.getDomNode().getAttributes().getNamedItemNS(MAIN_NAMESPACE, "val")) != null) {
            String value = attr.getValue();
            try {
                tblLook = Integer.parseInt(value, 16);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return tblLook;
    }

    public static boolean canApplyFirstRow(int tblLookVal) {
        int mask = 32;
        return (tblLookVal & mask) == mask;
    }

    public static boolean canApplyLastRow(int tblLookVal) {
        int mask = 64;
        return (tblLookVal & mask) == mask;
    }

    public static boolean canApplyFirstCol(int tblLookVal) {
        int mask = 128;
        return (tblLookVal & mask) == mask;
    }

    public static boolean canApplyLastCol(int tblLookVal) {
        int mask = 256;
        return (tblLookVal & mask) == mask;
    }
}

